/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model.debezium;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.common.model.debezium.AbstractDebeziumAvroPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieDebeziumAvroPayloadException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresDebeziumAvroPayload
extends AbstractDebeziumAvroPayload {
    private static final Logger LOG = LoggerFactory.getLogger(PostgresDebeziumAvroPayload.class);
    public static final String DEBEZIUM_TOASTED_VALUE = "__debezium_unavailable_value";

    public PostgresDebeziumAvroPayload(GenericRecord record, Comparable orderingVal) {
        super(record, orderingVal);
    }

    public PostgresDebeziumAvroPayload(Option<GenericRecord> record) {
        super(record);
    }

    private Option<Long> extractLSN(IndexedRecord record) {
        Object value = ((GenericRecord)record).get("_event_lsn");
        return Option.ofNullable(value != null ? (Long)value : null);
    }

    @Override
    protected boolean shouldPickCurrentRecord(IndexedRecord currentRecord, IndexedRecord insertRecord, Schema schema) throws IOException {
        Long insertSourceLSN = this.extractLSN(insertRecord).orElseThrow(() -> new HoodieDebeziumAvroPayloadException(String.format("%s cannot be null in insert record: %s", "_event_lsn", insertRecord)));
        Option<Long> currentSourceLSNOpt = this.extractLSN(currentRecord);
        return currentSourceLSNOpt.isPresent() && insertSourceLSN < currentSourceLSNOpt.get();
    }

    @Override
    public Option<IndexedRecord> combineAndGetUpdateValue(IndexedRecord currentValue, Schema schema, Properties properties) throws IOException {
        Option<IndexedRecord> insertOrDeleteRecord = super.combineAndGetUpdateValue(currentValue, schema, properties);
        if (insertOrDeleteRecord.isPresent()) {
            this.mergeToastedValuesIfPresent(insertOrDeleteRecord.get(), currentValue);
        }
        return insertOrDeleteRecord;
    }

    @Override
    public Option<IndexedRecord> combineAndGetUpdateValue(IndexedRecord currentValue, Schema schema) throws IOException {
        Option<IndexedRecord> insertOrDeleteRecord = super.combineAndGetUpdateValue(currentValue, schema);
        if (insertOrDeleteRecord.isPresent()) {
            this.mergeToastedValuesIfPresent(insertOrDeleteRecord.get(), currentValue);
        }
        return insertOrDeleteRecord;
    }

    private void mergeToastedValuesIfPresent(IndexedRecord incomingRecord, IndexedRecord currentRecord) {
        List fields = incomingRecord.getSchema().getFields();
        fields.forEach(field2 -> {
            if (((GenericData.Record)incomingRecord).get(field2.name()) != null && (this.containsStringToastedValues(incomingRecord, (Schema.Field)field2) || this.containsBytesToastedValues(incomingRecord, (Schema.Field)field2))) {
                ((GenericData.Record)incomingRecord).put(field2.name(), ((GenericData.Record)currentRecord).get(field2.name()));
            }
        });
    }

    private boolean containsStringToastedValues(IndexedRecord incomingRecord, Schema.Field field2) {
        return (field2.schema().getType() == Schema.Type.STRING || field2.schema().getType() == Schema.Type.UNION && field2.schema().getTypes().stream().anyMatch(s -> s.getType() == Schema.Type.STRING)) && ((CharSequence)((GenericData.Record)incomingRecord).get(field2.name())).length() == DEBEZIUM_TOASTED_VALUE.length() && DEBEZIUM_TOASTED_VALUE.equals(((CharSequence)((GenericData.Record)incomingRecord).get(field2.name())).toString());
    }

    private boolean containsBytesToastedValues(IndexedRecord incomingRecord, Schema.Field field2) {
        return (field2.schema().getType() == Schema.Type.BYTES || field2.schema().getType() == Schema.Type.UNION && field2.schema().getTypes().stream().anyMatch(s -> s.getType() == Schema.Type.BYTES)) && ((ByteBuffer)((GenericData.Record)incomingRecord).get(field2.name())).array().length == DEBEZIUM_TOASTED_VALUE.length() && DEBEZIUM_TOASTED_VALUE.equals(new String(((ByteBuffer)((GenericData.Record)incomingRecord).get(field2.name())).array(), StandardCharsets.UTF_8));
    }
}

