/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.dto;

import io.hops.hudi.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.hops.hudi.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hudi.common.model.CompactionOperation;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CompactionOpDTO {
    @JsonProperty(value="baseInstant")
    String baseInstantTime;
    @JsonProperty(value="compactionInstant")
    String compactionInstantTime;
    @JsonProperty(value="dataFileInstant")
    private String dataFileCommitTime;
    @JsonProperty(value="deltaFiles")
    private List<String> deltaFilePaths;
    @JsonProperty(value="baseFile")
    private String dataFilePath;
    @JsonProperty(value="id")
    private String fileId;
    @JsonProperty(value="partition")
    private String partitionPath;
    @JsonProperty(value="metrics")
    private Map<String, Double> metrics;
    @JsonProperty(value="bootstrapBaseFile")
    private String bootstrapBaseFile;

    public static CompactionOpDTO fromCompactionOperation(String compactionInstantTime, CompactionOperation op) {
        CompactionOpDTO dto = new CompactionOpDTO();
        dto.fileId = op.getFileId();
        dto.compactionInstantTime = compactionInstantTime;
        dto.baseInstantTime = op.getBaseInstantTime();
        dto.dataFileCommitTime = op.getDataFileCommitTime().orElse(null);
        dto.dataFilePath = op.getDataFileName().orElse(null);
        dto.deltaFilePaths = new ArrayList<String>(op.getDeltaFileNames());
        dto.partitionPath = op.getPartitionPath();
        dto.metrics = op.getMetrics() == null ? new HashMap<String, Double>() : new HashMap<String, Double>(op.getMetrics());
        dto.bootstrapBaseFile = op.getBootstrapFilePath().orElse(null);
        return dto;
    }

    public static Pair<String, CompactionOperation> toCompactionOperation(CompactionOpDTO dto) {
        return Pair.of(dto.compactionInstantTime, new CompactionOperation(dto.fileId, dto.partitionPath, dto.baseInstantTime, Option.ofNullable(dto.dataFileCommitTime), dto.deltaFilePaths, Option.ofNullable(dto.dataFilePath), Option.ofNullable(dto.bootstrapBaseFile), dto.metrics));
    }
}

