/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.model.HoodieAvroRecordMerger;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.OperationModeAwareness;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieRecordUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieRecordUtils.class);
    private static final Map<String, Object> INSTANCE_CACHE = new HashMap<String, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HoodieRecordMerger loadRecordMerger(String mergerClass) {
        try {
            HoodieRecordMerger recordMerger = (HoodieRecordMerger)INSTANCE_CACHE.get(mergerClass);
            if (null != recordMerger) return recordMerger;
            Class<HoodieRecordMerger> clazz = HoodieRecordMerger.class;
            synchronized (HoodieRecordMerger.class) {
                recordMerger = (HoodieRecordMerger)INSTANCE_CACHE.get(mergerClass);
                if (null != recordMerger) return recordMerger;
                recordMerger = (HoodieRecordMerger)ReflectionUtils.loadClass(mergerClass, new Object[0]);
                INSTANCE_CACHE.put(mergerClass, recordMerger);
                // ** MonitorExit[var2_3] (shouldn't be in output)
                return recordMerger;
            }
        }
        catch (HoodieException e) {
            throw new HoodieException("Unable to instantiate hoodie merge class ", e);
        }
    }

    public static HoodieRecordMerger createRecordMerger(String basePath, EngineType engineType, List<String> mergerClassList, String recordMergerStrategy) {
        if (mergerClassList.isEmpty() || HoodieTableMetadata.isMetadataTable(basePath)) {
            return HoodieAvroRecordMerger.INSTANCE;
        }
        return mergerClassList.stream().map(clazz -> HoodieRecordUtils.loadRecordMerger(clazz)).filter(Objects::nonNull).filter(merger -> merger.getMergingStrategy().equals(recordMergerStrategy)).filter(merger -> HoodieRecordUtils.recordTypeCompatibleEngine(merger.getRecordType(), engineType)).findFirst().orElse(HoodieAvroRecordMerger.INSTANCE);
    }

    public static <T extends HoodieRecordPayload> T loadPayload(String recordPayloadClass, Object[] payloadArgs, Class<?> ... constructorArgTypes) {
        try {
            return (T)((HoodieRecordPayload)ReflectionUtils.getClass(recordPayloadClass).getConstructor(constructorArgTypes).newInstance(payloadArgs));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new HoodieException("Unable to instantiate payload class ", e);
        }
    }

    public static boolean recordTypeCompatibleEngine(HoodieRecord.HoodieRecordType recordType, EngineType engineType) {
        return engineType == EngineType.SPARK && recordType == HoodieRecord.HoodieRecordType.SPARK;
    }

    public static HoodieRecordMerger mergerToPreCombineMode(HoodieRecordMerger merger) {
        return merger instanceof OperationModeAwareness ? ((OperationModeAwareness)((Object)merger)).asPreCombiningMode() : merger;
    }

    static {
        INSTANCE_CACHE.put(HoodieAvroRecordMerger.class.getName(), HoodieAvroRecordMerger.INSTANCE);
    }
}

