/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.convert.AvroInternalSchemaConverter;
import org.apache.hudi.internal.schema.io.FileBasedInternalSchemaStorageManager;
import org.apache.hudi.internal.schema.utils.InternalSchemaUtils;
import org.apache.hudi.internal.schema.utils.SerDeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalSchemaCache {
    private static final Logger LOG = LoggerFactory.getLogger(InternalSchemaCache.class);
    private static Object[] lockList = new Object[16];
    private static final Cache<String, TreeMap<Long, InternalSchema>> HISTORICAL_SCHEMA_CACHE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InternalSchema searchSchemaAndCache(long versionID, HoodieTableMetaClient metaClient, boolean cacheEnable) {
        Option<InternalSchema> candidateSchema = InternalSchemaCache.getSchemaByReadingCommitFile(versionID, metaClient);
        if (candidateSchema.isPresent()) {
            return candidateSchema.get();
        }
        if (!cacheEnable) {
            return InternalSchemaUtils.searchSchema(versionID, InternalSchemaCache.getHistoricalSchemas(metaClient));
        }
        String tablePath = metaClient.getBasePath();
        Object object = lockList[tablePath.hashCode() & lockList.length - 1];
        synchronized (object) {
            TreeMap<Long, InternalSchema> historicalSchemas = (TreeMap<Long, InternalSchema>)HISTORICAL_SCHEMA_CACHE.getIfPresent((Object)tablePath);
            if (historicalSchemas == null || InternalSchemaUtils.searchSchema(versionID, historicalSchemas) == null) {
                historicalSchemas = InternalSchemaCache.getHistoricalSchemas(metaClient);
                HISTORICAL_SCHEMA_CACHE.put((Object)tablePath, historicalSchemas);
            } else {
                long maxVersionId = (Long)historicalSchemas.keySet().stream().max(Long::compareTo).get();
                if (versionID > maxVersionId) {
                    historicalSchemas = InternalSchemaCache.getHistoricalSchemas(metaClient);
                    HISTORICAL_SCHEMA_CACHE.put((Object)tablePath, historicalSchemas);
                }
            }
            return InternalSchemaUtils.searchSchema(versionID, historicalSchemas);
        }
    }

    private static TreeMap<Long, InternalSchema> getHistoricalSchemas(HoodieTableMetaClient metaClient) {
        TreeMap<Long, InternalSchema> result = new TreeMap<Long, InternalSchema>();
        FileBasedInternalSchemaStorageManager schemasManager = new FileBasedInternalSchemaStorageManager(metaClient);
        String historySchemaStr = schemasManager.getHistorySchemaStr();
        if (!StringUtils.isNullOrEmpty(historySchemaStr)) {
            result = SerDeHelper.parseSchemas(historySchemaStr);
        }
        return result;
    }

    private static Option<InternalSchema> getSchemaByReadingCommitFile(long versionID, HoodieTableMetaClient metaClient) {
        try {
            HoodieTimeline timeline = metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants();
            List instants = timeline.getInstantsAsStream().filter(f -> f.getTimestamp().equals(String.valueOf(versionID))).collect(Collectors.toList());
            if (instants.isEmpty()) {
                return Option.empty();
            }
            byte[] data = timeline.getInstantDetails((HoodieInstant)instants.get(0)).get();
            HoodieCommitMetadata metadata = HoodieCommitMetadata.fromBytes(data, HoodieCommitMetadata.class);
            String latestInternalSchemaStr = metadata.getMetadata("latest_schema");
            return SerDeHelper.fromJson(latestInternalSchemaStr);
        }
        catch (Exception e) {
            throw new HoodieException("Failed to read schema from commit metadata", e);
        }
    }

    public static Pair<Option<String>, Option<String>> getInternalSchemaAndAvroSchemaForClusteringAndCompaction(HoodieTableMetaClient metaClient, String compactionAndClusteringInstant) {
        HoodieTimeline timelineBeforeCurrentCompaction = metaClient.getCommitsAndCompactionTimeline().findInstantsBefore(compactionAndClusteringInstant).filterCompletedInstants();
        Option<HoodieInstant> lastInstantBeforeCurrentCompaction = timelineBeforeCurrentCompaction.lastInstant();
        if (lastInstantBeforeCurrentCompaction.isPresent()) {
            HoodieCommitMetadata metadata;
            byte[] data = timelineBeforeCurrentCompaction.getInstantDetails(lastInstantBeforeCurrentCompaction.get()).get();
            try {
                metadata = HoodieCommitMetadata.fromBytes(data, HoodieCommitMetadata.class);
            }
            catch (Exception e) {
                throw new HoodieException(String.format("cannot read metadata from commit: %s", lastInstantBeforeCurrentCompaction.get()), e);
            }
            String internalSchemaStr = metadata.getMetadata("latest_schema");
            if (internalSchemaStr != null) {
                String existingSchemaStr = metadata.getMetadata("schema");
                return Pair.of(Option.of(internalSchemaStr), Option.of(existingSchemaStr));
            }
        }
        return Pair.of(Option.empty(), Option.empty());
    }

    public static InternalSchema getInternalSchemaByVersionId(long versionId, String tablePath, Configuration hadoopConf, String validCommits) {
        FileBasedInternalSchemaStorageManager fileBasedInternalSchemaStorageManager;
        String latestHistorySchema;
        String avroSchema = "";
        Set commitSet = Arrays.stream(validCommits.split(",")).collect(Collectors.toSet());
        List<String> validateCommitList = commitSet.stream().map(HoodieInstant::extractTimestamp).collect(Collectors.toList());
        FileSystem fs = FSUtils.getFs(tablePath, hadoopConf);
        Path hoodieMetaPath = new Path(tablePath, ".hoodie");
        Path candidateCommitFile = commitSet.stream().filter(fileName -> HoodieInstant.extractTimestamp(fileName).equals(versionId + "")).findFirst().map(f -> new Path(hoodieMetaPath, f)).orElse(null);
        if (candidateCommitFile != null) {
            try {
                byte[] data;
                try (FSDataInputStream is = fs.open(candidateCommitFile);){
                    data = FileIOUtils.readAsByteArray((InputStream)is);
                }
                HoodieCommitMetadata metadata = HoodieCommitMetadata.fromBytes(data, HoodieCommitMetadata.class);
                String latestInternalSchemaStr = metadata.getMetadata("latest_schema");
                avroSchema = metadata.getMetadata("schema");
                if (latestInternalSchemaStr != null) {
                    return SerDeHelper.fromJson(latestInternalSchemaStr).orElse(null);
                }
            }
            catch (Exception e1) {
                LOG.warn(String.format("Cannot find internal schema from commit file %s. Falling back to parsing historical internal schema", candidateCommitFile.toString()));
            }
        }
        if ((latestHistorySchema = (fileBasedInternalSchemaStorageManager = new FileBasedInternalSchemaStorageManager(hadoopConf, new Path(tablePath))).getHistorySchemaStrByGivenValidCommits(validateCommitList)).isEmpty()) {
            return InternalSchema.getEmptyInternalSchema();
        }
        InternalSchema fileSchema = InternalSchemaUtils.searchSchema(versionId, SerDeHelper.parseSchemas(latestHistorySchema));
        return fileSchema.isEmptySchema() ? AvroInternalSchemaConverter.convert(HoodieAvroUtils.addMetadataFields(new Schema.Parser().parse(avroSchema))) : fileSchema;
    }

    public static InternalSchema getInternalSchemaByVersionId(long versionId, HoodieTableMetaClient metaClient) {
        String validCommitLists = metaClient.getCommitsAndCompactionTimeline().filterCompletedInstants().getInstantsAsStream().map(HoodieInstant::getFileName).collect(Collectors.joining(","));
        return InternalSchemaCache.getInternalSchemaByVersionId(versionId, metaClient.getBasePathV2().toString(), metaClient.getHadoopConf(), validCommitLists);
    }

    static {
        for (int i = 0; i < lockList.length; ++i) {
            InternalSchemaCache.lockList[i] = new Object();
        }
        HISTORICAL_SCHEMA_CACHE = Caffeine.newBuilder().maximumSize(1000L).weakValues().build();
    }
}

