/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.connect.writers;

import java.util.Map;
import java.util.Properties;
import javax.annotation.concurrent.Immutable;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.hive.HiveSyncTool;
import org.apache.hudi.schema.FilebasedSchemaProvider;

@ConfigClassProperty(name="Kafka Sink Connect Configurations", groupName=ConfigGroups.Names.KAFKA_CONNECT, description="Configurations for Kafka Connect Sink Connector for Hudi.")
@Immutable
public class KafkaConnectConfigs
extends HoodieConfig {
    public static final int CURRENT_PROTOCOL_VERSION = 0;
    public static final String KAFKA_VALUE_CONVERTER = "value.converter";
    public static final ConfigProperty<String> KAFKA_BOOTSTRAP_SERVERS = ConfigProperty.key("bootstrap.servers").defaultValue("localhost:9092").withDocumentation("The bootstrap servers for the Kafka Cluster.");
    public static final ConfigProperty<String> CONTROL_TOPIC_NAME = ConfigProperty.key("hoodie.kafka.control.topic").defaultValue("hudi-control-topic").markAdvanced().withDocumentation("Kafka topic name used by the Hudi Sink Connector for sending and receiving control messages. Not used for data records.");
    public static final ConfigProperty<String> SCHEMA_PROVIDER_CLASS = ConfigProperty.key("hoodie.schemaprovider.class").defaultValue(FilebasedSchemaProvider.class.getName()).markAdvanced().withDocumentation("subclass of org.apache.hudi.schema.SchemaProvider to attach schemas to input & target table data, built in options: org.apache.hudi.schema.FilebasedSchemaProvider.");
    public static final ConfigProperty<String> COMMIT_INTERVAL_SECS = ConfigProperty.key("hoodie.kafka.commit.interval.secs").defaultValue("60").markAdvanced().withDocumentation("The interval at which Hudi will commit the records written to the files, making them consumable on the read-side.");
    public static final ConfigProperty<String> COORDINATOR_WRITE_TIMEOUT_SECS = ConfigProperty.key("hoodie.kafka.coordinator.write.timeout.secs").defaultValue("300").markAdvanced().withDocumentation("The timeout after sending an END_COMMIT until when the coordinator will wait for the write statuses from all the partitionsto ignore the current commit and start a new commit.");
    public static final ConfigProperty<String> ASYNC_COMPACT_ENABLE = ConfigProperty.key("hoodie.kafka.compaction.async.enable").defaultValue("true").markAdvanced().withDocumentation("Controls whether async compaction should be turned on for MOR table writing.");
    public static final ConfigProperty<String> META_SYNC_ENABLE = ConfigProperty.key("hoodie.meta.sync.enable").defaultValue("false").markAdvanced().withDocumentation("Enable Meta Sync such as Hive");
    public static final ConfigProperty<String> META_SYNC_CLASSES = ConfigProperty.key("hoodie.meta.sync.classes").defaultValue(HiveSyncTool.class.getName()).markAdvanced().withDocumentation("Meta sync client tool, using comma to separate multi tools");
    public static final ConfigProperty<Boolean> ALLOW_COMMIT_ON_ERRORS = ConfigProperty.key("hoodie.kafka.allow.commit.on.errors").defaultValue(true).markAdvanced().withDocumentation("Commit even when some records failed to be written");
    public static final ConfigProperty<String> HADOOP_CONF_DIR = ConfigProperty.key("hadoop.conf.dir").noDefaultValue().markAdvanced().withDocumentation("The Hadoop configuration directory.");
    public static final ConfigProperty<String> HADOOP_HOME = ConfigProperty.key("hadoop.home").noDefaultValue().markAdvanced().withDocumentation("The Hadoop home directory.");
    public static final String HIVE_USE_PRE_APACHE_INPUT_FORMAT = "hoodie.datasource.hive_sync.use_pre_apache_input_format";
    public static final String HIVE_DATABASE = "hoodie.datasource.hive_sync.database";
    public static final String HIVE_TABLE = "hoodie.datasource.hive_sync.table";
    public static final String HIVE_USER = "hoodie.datasource.hive_sync.username";
    public static final String HIVE_PASS = "hoodie.datasource.hive_sync.password";
    public static final String HIVE_URL = "hoodie.datasource.hive_sync.jdbcurl";
    public static final String HIVE_PARTITION_FIELDS = "hoodie.datasource.hive_sync.partition_fields";
    public static final String HIVE_PARTITION_EXTRACTOR_CLASS = "hoodie.datasource.hive_sync.partition_extractor_class";
    public static final String HIVE_USE_JDBC = "hoodie.datasource.hive_sync.use_jdbc";
    public static final String HIVE_SYNC_MODE = "hoodie.datasource.hive_sync.mode";
    public static final String HIVE_AUTO_CREATE_DATABASE = "hoodie.datasource.hive_sync.auto_create_database";
    public static final String HIVE_IGNORE_EXCEPTIONS = "hoodie.datasource.hive_sync.ignore_exceptions";
    public static final String HIVE_SKIP_RO_SUFFIX_FOR_READ_OPTIMIZED_TABLE = "hoodie.datasource.hive_sync.skip_ro_suffix";
    public static final String HIVE_SUPPORT_TIMESTAMP_TYPE = "hoodie.datasource.hive_sync.support_timestamp";
    public static final String HIVE_METASTORE_URIS = "hive.metastore.uris";

    protected KafkaConnectConfigs() {
    }

    protected KafkaConnectConfigs(Properties props) {
        super(props);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getBootstrapServers() {
        return this.getString(KAFKA_BOOTSTRAP_SERVERS);
    }

    public String getControlTopicName() {
        return this.getString(CONTROL_TOPIC_NAME);
    }

    public String getSchemaProviderClass() {
        return this.getString(SCHEMA_PROVIDER_CLASS);
    }

    public Long getCommitIntervalSecs() {
        return this.getLong(COMMIT_INTERVAL_SECS);
    }

    public Long getCoordinatorWriteTimeoutSecs() {
        return this.getLong(COORDINATOR_WRITE_TIMEOUT_SECS);
    }

    public String getKafkaValueConverter() {
        return this.getString(KAFKA_VALUE_CONVERTER);
    }

    public Boolean isAsyncCompactEnabled() {
        return this.getBoolean(ASYNC_COMPACT_ENABLE);
    }

    public Boolean isMetaSyncEnabled() {
        return this.getBoolean(META_SYNC_ENABLE);
    }

    public String getMetaSyncClasses() {
        return this.getString(META_SYNC_CLASSES);
    }

    public Boolean allowCommitOnErrors() {
        return this.getBoolean(ALLOW_COMMIT_ON_ERRORS);
    }

    public String getHadoopConfDir() {
        return this.getString(HADOOP_CONF_DIR);
    }

    public String getHadoopConfHome() {
        return this.getString(HADOOP_HOME);
    }

    public static class Builder {
        protected final KafkaConnectConfigs connectConfigs = new KafkaConnectConfigs();

        public Builder withBootstrapServers(String bootstrapServers) {
            this.connectConfigs.setValue(KAFKA_BOOTSTRAP_SERVERS, bootstrapServers);
            return this;
        }

        public Builder withControlTopicName(String controlTopicName) {
            this.connectConfigs.setValue(CONTROL_TOPIC_NAME, controlTopicName);
            return this;
        }

        public Builder withCommitIntervalSecs(Long commitIntervalSecs) {
            this.connectConfigs.setValue(COMMIT_INTERVAL_SECS, String.valueOf(commitIntervalSecs));
            return this;
        }

        public Builder withCoordinatorWriteTimeoutSecs(Long coordinatorWriteTimeoutSecs) {
            this.connectConfigs.setValue(COORDINATOR_WRITE_TIMEOUT_SECS, String.valueOf(coordinatorWriteTimeoutSecs));
            return this;
        }

        public Builder withAllowCommitOnErrors(Boolean allowCommitOnErrors) {
            this.connectConfigs.setValue(ALLOW_COMMIT_ON_ERRORS, String.valueOf(allowCommitOnErrors));
            return this;
        }

        public Builder withProperties(Map<?, ?> properties) {
            this.connectConfigs.getProps().putAll(properties);
            return this;
        }

        public Builder withProperties(Properties properties) {
            this.connectConfigs.getProps().putAll((Map<?, ?>)properties);
            return this;
        }

        public Builder withHadoopConfDir(String hadoopConfDir) {
            this.connectConfigs.setValue(HADOOP_CONF_DIR, String.valueOf(hadoopConfDir));
            return this;
        }

        public Builder withHadoopHome(String hadoopHome) {
            this.connectConfigs.setValue(HADOOP_HOME, String.valueOf(hadoopHome));
            return this;
        }

        protected void setDefaults() {
            this.connectConfigs.setDefaults(KafkaConnectConfigs.class.getName());
        }

        public KafkaConnectConfigs build() {
            this.setDefaults();
            return new KafkaConnectConfigs((Properties)this.connectConfigs.getProps());
        }
    }
}

