/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution.bulkinsert;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.collection.FlatLists;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.BulkInsertPartitioner;

public class JavaCustomColumnsSortPartitioner<T>
implements BulkInsertPartitioner<List<HoodieRecord<T>>> {
    private final String[] sortColumnNames;
    private final Schema schema;
    private final boolean consistentLogicalTimestampEnabled;

    public JavaCustomColumnsSortPartitioner(String[] columnNames, Schema schema, HoodieWriteConfig config) {
        this.sortColumnNames = BulkInsertPartitioner.tryPrependPartitionPathColumns(columnNames, config);
        this.schema = schema;
        this.consistentLogicalTimestampEnabled = config.isConsistentLogicalTimestampEnabled();
    }

    @Override
    public List<HoodieRecord<T>> repartitionRecords(List<HoodieRecord<T>> records, int outputPartitions) {
        return records.stream().sorted((o1, o2) -> {
            FlatLists.ComparableList values1 = FlatLists.ofComparableArray(HoodieAvroUtils.getRecordColumnValues((HoodieAvroRecord)o1, this.sortColumnNames, this.schema, this.consistentLogicalTimestampEnabled));
            FlatLists.ComparableList values2 = FlatLists.ofComparableArray(HoodieAvroUtils.getRecordColumnValues((HoodieAvroRecord)o2, this.sortColumnNames, this.schema, this.consistentLogicalTimestampEnabled));
            return values1.compareTo(values2);
        }).collect(Collectors.toList());
    }

    @Override
    public boolean arePartitionRecordsSorted() {
        return true;
    }
}

