/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop;

import java.io.IOException;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.RecordReader;

public class SafeParquetRecordReaderWrapper
implements RecordReader<NullWritable, ArrayWritable> {
    private final RecordReader<NullWritable, ArrayWritable> parquetReader;
    private final Class valueClass;
    private final int numValueFields;

    public SafeParquetRecordReaderWrapper(RecordReader<NullWritable, ArrayWritable> parquetReader) {
        this.parquetReader = parquetReader;
        ArrayWritable arrayWritable = (ArrayWritable)parquetReader.createValue();
        this.valueClass = arrayWritable.getValueClass();
        this.numValueFields = arrayWritable.get().length;
    }

    public boolean next(NullWritable key, ArrayWritable value) throws IOException {
        return this.parquetReader.next((Object)key, (Object)value);
    }

    public NullWritable createKey() {
        return (NullWritable)this.parquetReader.createKey();
    }

    public ArrayWritable createValue() {
        Writable[] emptyWritableBuf = new Writable[this.numValueFields];
        return new ArrayWritable(this.valueClass, emptyWritableBuf);
    }

    public long getPos() throws IOException {
        return this.parquetReader.getPos();
    }

    public void close() throws IOException {
        this.parquetReader.close();
    }

    public float getProgress() throws IOException {
        return this.parquetReader.getProgress();
    }
}

