/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.internal.schema.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hudi.internal.schema.HoodieSchemaException;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.InternalSchemaBuilder;
import org.apache.hudi.internal.schema.Type;
import org.apache.hudi.internal.schema.Types;
import org.apache.hudi.internal.schema.action.TableChange;
import org.apache.hudi.internal.schema.action.TableChangesHelper;
import org.apache.hudi.internal.schema.utils.SchemaChangeUtils;

public class TableChanges {

    public static class ColumnAddChange
    extends TableChange.BaseColumnChange {
        private final Map<String, Integer> fullColName2Id = new HashMap<String, Integer>();
        private final Map<Integer, ArrayList<Types.Field>> parentId2AddCols = new HashMap<Integer, ArrayList<Types.Field>>();
        private int nextId;

        public static ColumnAddChange get(InternalSchema internalSchema) {
            return new ColumnAddChange(internalSchema);
        }

        public Type applyAdd(Types.Field originalField, Type type) {
            int fieldId = originalField.fieldId();
            ArrayList<Types.Field> addFields = this.parentId2AddCols.getOrDefault(fieldId, new ArrayList());
            ArrayList<TableChange.ColumnPositionChange> pchanges = this.positionChangeMap.getOrDefault(fieldId, new ArrayList());
            if (!addFields.isEmpty() || !pchanges.isEmpty()) {
                List<Types.Field> newFields = TableChangesHelper.applyAddChange2Fields(((Types.RecordType)type).fields(), addFields, pchanges);
                return Types.RecordType.get(newFields);
            }
            return type;
        }

        public ColumnAddChange addColumns(String name, Type type, String doc) {
            this.checkColModifyIsLegal(name);
            return this.addColumns("", name, type, doc);
        }

        public ColumnAddChange addColumns(String parent, String name, Type type, String doc) {
            this.checkColModifyIsLegal(name);
            this.addColumnsInternal(parent, name, type, doc);
            return this;
        }

        private void addColumnsInternal(String parent, String name, Type type, String doc) {
            int parentId = -1;
            String fullName = name;
            if (!parent.isEmpty()) {
                Types.Field parentField = this.internalSchema.findField(parent);
                if (parentField == null) {
                    throw new HoodieSchemaException(String.format("cannot add column: %s which parent: %s is not exist", name, parent));
                }
                Type parentType = parentField.type();
                if (!(parentField.type() instanceof Types.RecordType)) {
                    throw new HoodieSchemaException("only support add nested columns to struct column");
                }
                parentId = parentField.fieldId();
                Types.Field newParentField = this.internalSchema.findField(parent + "." + name);
                if (newParentField != null) {
                    throw new HoodieSchemaException(String.format("cannot add column: %s which already exist", name));
                }
                fullName = parent + "." + name;
            } else if (this.internalSchema.hasColumn(name, this.caseSensitive)) {
                throw new HoodieSchemaException(String.format("cannot add column: %s which already exist", name));
            }
            if (this.fullColName2Id.containsKey(fullName)) {
                throw new HoodieSchemaException(String.format("cannot repeat add column: %s", name));
            }
            this.fullColName2Id.put(fullName, this.nextId);
            if (parentId != -1) {
                this.id2parent.put(this.nextId, parentId);
            }
            AtomicInteger assignNextId = new AtomicInteger(this.nextId + 1);
            Type typeWithNewId = InternalSchemaBuilder.getBuilder().refreshNewId(type, assignNextId);
            ArrayList<Types.Field> adds = this.parentId2AddCols.getOrDefault(parentId, new ArrayList());
            adds.add(Types.Field.get(this.nextId, true, name, typeWithNewId, doc));
            this.parentId2AddCols.put(parentId, adds);
            this.nextId = assignNextId.get();
        }

        private ColumnAddChange(InternalSchema internalSchema) {
            super(internalSchema);
            this.nextId = internalSchema.getMaxColumnId() + 1;
        }

        public Map<Integer, ArrayList<Types.Field>> getParentId2AddCols() {
            return this.parentId2AddCols;
        }

        public Map<Integer, ArrayList<TableChange.ColumnPositionChange>> getPositionChangeMap() {
            return this.positionChangeMap;
        }

        public Map<String, Integer> getFullColName2Id() {
            return this.fullColName2Id;
        }

        @Override
        protected Integer findIdByFullName(String fullName) {
            Types.Field field2 = this.internalSchema.findField(fullName);
            if (field2 != null) {
                return field2.fieldId();
            }
            return this.fullColName2Id.getOrDefault(fullName, -1);
        }

        @Override
        public TableChange.ColumnChangeID columnChangeId() {
            return TableChange.ColumnChangeID.ADD;
        }

        @Override
        public boolean withPositionChange() {
            return true;
        }
    }

    public static class ColumnDeleteChange
    extends TableChange.BaseColumnChange {
        private final Set deletes = new HashSet();

        @Override
        public TableChange.ColumnChangeID columnChangeId() {
            return TableChange.ColumnChangeID.DELETE;
        }

        public static ColumnDeleteChange get(InternalSchema schema) {
            return new ColumnDeleteChange(schema);
        }

        private ColumnDeleteChange(InternalSchema schema) {
            super(schema);
        }

        @Override
        public boolean withPositionChange() {
            return false;
        }

        @Override
        public TableChange.BaseColumnChange addPositionChange(String srcId, String dsrId, String orderType) {
            throw new UnsupportedOperationException("no support add position change for ColumnDeleteChange");
        }

        public ColumnDeleteChange deleteColumn(String name) {
            this.checkColModifyIsLegal(name);
            Types.Field field2 = this.internalSchema.findField(name);
            if (field2 == null) {
                throw new IllegalArgumentException(String.format("cannot delete missing columns: %s", name));
            }
            this.deletes.add(field2.fieldId());
            return this;
        }

        public Type applyDelete(int id, Type type) {
            if (this.deletes.contains(id)) {
                return null;
            }
            return type;
        }

        public Set<Integer> getDeletes() {
            return this.deletes;
        }

        @Override
        protected Integer findIdByFullName(String fullName) {
            throw new UnsupportedOperationException("delete change cannot support this method");
        }
    }

    public static class ColumnUpdateChange
    extends TableChange.BaseColumnChange {
        private final Map<Integer, Types.Field> updates = new HashMap<Integer, Types.Field>();

        private ColumnUpdateChange(InternalSchema schema) {
            super(schema, false);
        }

        private ColumnUpdateChange(InternalSchema schema, boolean caseSensitive) {
            super(schema, caseSensitive);
        }

        @Override
        public boolean withPositionChange() {
            return true;
        }

        public Type applyUpdates(Types.Field oldField, Type type) {
            Types.Field update = this.updates.get(oldField.fieldId());
            if (update != null && update.type() != oldField.type()) {
                return update.type();
            }
            ArrayList<TableChange.ColumnPositionChange> pchanges = this.positionChangeMap.getOrDefault(oldField.fieldId(), new ArrayList());
            if (!pchanges.isEmpty()) {
                List<Types.Field> newFields = TableChangesHelper.applyAddChange2Fields(((Types.RecordType)type).fields(), new ArrayList<Types.Field>(), pchanges);
                return Types.RecordType.get(newFields);
            }
            return type;
        }

        public Map<Integer, Types.Field> getUpdates() {
            return this.updates;
        }

        public ColumnUpdateChange updateColumnType(String name, Type newType) {
            this.checkColModifyIsLegal(name);
            if (newType.isNestedType()) {
                throw new IllegalArgumentException(String.format("only support update primitive type but find nest column: %s", name));
            }
            Types.Field field2 = this.internalSchema.findField(name);
            if (field2 == null) {
                throw new IllegalArgumentException(String.format("cannot update a missing column: %s", name));
            }
            if (!SchemaChangeUtils.isTypeUpdateAllow(field2.type(), newType)) {
                throw new IllegalArgumentException(String.format("cannot update origin type: %s to a incompatibility type: %s", field2.type(), newType));
            }
            if (field2.type().equals(newType)) {
                return this;
            }
            Types.Field update = this.updates.get(field2.fieldId());
            if (update == null) {
                this.updates.put(field2.fieldId(), Types.Field.get(field2.fieldId(), field2.isOptional(), field2.name(), newType, field2.doc()));
            } else {
                this.updates.put(field2.fieldId(), Types.Field.get(field2.fieldId(), update.isOptional(), update.name(), newType, update.doc()));
            }
            return this;
        }

        public ColumnUpdateChange updateColumnComment(String name, String newDoc) {
            this.checkColModifyIsLegal(name);
            Types.Field field2 = this.internalSchema.findField(name);
            if (field2 == null) {
                throw new IllegalArgumentException(String.format("cannot update a missing column: %s", name));
            }
            if (Objects.equals(field2.doc(), newDoc)) {
                return this;
            }
            Types.Field update = this.updates.get(field2.fieldId());
            if (update == null) {
                this.updates.put(field2.fieldId(), Types.Field.get(field2.fieldId(), field2.isOptional(), field2.name(), field2.type(), newDoc));
            } else {
                this.updates.put(field2.fieldId(), Types.Field.get(field2.fieldId(), update.isOptional(), update.name(), update.type(), newDoc));
            }
            return this;
        }

        public ColumnUpdateChange renameColumn(String name, String newName) {
            this.checkColModifyIsLegal(name);
            Types.Field field2 = this.internalSchema.findField(name);
            if (field2 == null) {
                throw new IllegalArgumentException(String.format("cannot update a missing column: %s", name));
            }
            if (newName == null || newName.isEmpty()) {
                throw new IllegalArgumentException(String.format("cannot rename column: %s to empty", name));
            }
            if (this.internalSchema.hasColumn(newName, this.caseSensitive)) {
                throw new IllegalArgumentException(String.format("cannot rename column: %s to a existing name", name));
            }
            Types.Field update = this.updates.get(field2.fieldId());
            if (update == null) {
                this.updates.put(field2.fieldId(), Types.Field.get(field2.fieldId(), field2.isOptional(), newName, field2.type(), field2.doc()));
            } else {
                this.updates.put(field2.fieldId(), Types.Field.get(field2.fieldId(), update.isOptional(), newName, update.type(), update.doc()));
            }
            return this;
        }

        public ColumnUpdateChange updateColumnNullability(String name, boolean nullable) {
            return this.updateColumnNullability(name, nullable, false);
        }

        public ColumnUpdateChange updateColumnNullability(String name, boolean nullable, boolean force) {
            this.checkColModifyIsLegal(name);
            Types.Field field2 = this.internalSchema.findField(name);
            if (field2 == null) {
                throw new IllegalArgumentException(String.format("cannot update a missing column: %s", name));
            }
            if (field2.isOptional() == nullable) {
                return this;
            }
            if (field2.isOptional() && !nullable && !force) {
                throw new IllegalArgumentException("cannot update column Nullability: optional to required");
            }
            Types.Field update = this.updates.get(field2.fieldId());
            if (update == null) {
                this.updates.put(field2.fieldId(), Types.Field.get(field2.fieldId(), nullable, field2.name(), field2.type(), field2.doc()));
            } else {
                this.updates.put(field2.fieldId(), Types.Field.get(field2.fieldId(), nullable, update.name(), update.type(), update.doc()));
            }
            return this;
        }

        public Map<Integer, ArrayList<TableChange.ColumnPositionChange>> getPositionChangeMap() {
            return this.positionChangeMap;
        }

        @Override
        public TableChange.ColumnChangeID columnChangeId() {
            return TableChange.ColumnChangeID.UPDATE;
        }

        @Override
        protected Integer findIdByFullName(String fullName) {
            Types.Field field2 = this.internalSchema.findField(fullName);
            if (field2 != null) {
                return field2.fieldId();
            }
            throw new IllegalArgumentException(String.format("cannot find col id for given column fullName: %s", fullName));
        }

        public static ColumnUpdateChange get(InternalSchema schema) {
            return new ColumnUpdateChange(schema);
        }

        public static ColumnUpdateChange get(InternalSchema schema, boolean caseSensitive) {
            return new ColumnUpdateChange(schema, caseSensitive);
        }
    }
}

