/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.avro.Schema;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieOperation;
import org.apache.hudi.common.model.HoodiePartitionMetadata;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.model.MetadataValues;
import org.apache.hudi.common.util.DefaultSizeEstimator;
import org.apache.hudi.common.util.HoodieRecordSizeEstimator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.ExternalSpillableMap;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieCorruptedDataException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieUpsertException;
import org.apache.hudi.io.HoodieWriteHandle;
import org.apache.hudi.io.IOUtils;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieFileReaderFactory;
import org.apache.hudi.io.storage.HoodieFileWriter;
import org.apache.hudi.io.storage.HoodieFileWriterFactory;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.table.HoodieTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class HoodieMergeHandle<T, I, K, O>
extends HoodieWriteHandle<T, I, K, O> {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieMergeHandle.class);
    protected Map<String, HoodieRecord<T>> keyToNewRecords;
    protected Set<String> writtenRecordKeys;
    protected HoodieFileWriter fileWriter;
    private boolean preserveMetadata = false;
    protected Path newFilePath;
    protected Path oldFilePath;
    protected long recordsWritten = 0L;
    protected long recordsDeleted = 0L;
    protected long updatedRecordsWritten = 0L;
    protected long insertRecordsWritten = 0L;
    protected boolean useWriterSchemaForCompaction;
    protected Option<BaseKeyGenerator> keyGeneratorOpt;
    private HoodieBaseFile baseFileToMerge;
    protected Option<String[]> partitionFields = Option.empty();
    protected Object[] partitionValues = new Object[0];

    public HoodieMergeHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> hoodieTable, Iterator<HoodieRecord<T>> recordItr, String partitionPath, String fileId, TaskContextSupplier taskContextSupplier, Option<BaseKeyGenerator> keyGeneratorOpt) {
        this(config, instantTime, hoodieTable, recordItr, partitionPath, fileId, taskContextSupplier, HoodieMergeHandle.getLatestBaseFile(hoodieTable, partitionPath, fileId), keyGeneratorOpt);
    }

    public HoodieMergeHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> hoodieTable, Iterator<HoodieRecord<T>> recordItr, String partitionPath, String fileId, TaskContextSupplier taskContextSupplier, HoodieBaseFile baseFile, Option<BaseKeyGenerator> keyGeneratorOpt) {
        super(config, instantTime, partitionPath, fileId, hoodieTable, taskContextSupplier);
        this.init(fileId, recordItr);
        this.init(fileId, partitionPath, baseFile);
        this.validateAndSetAndKeyGenProps(keyGeneratorOpt, config.populateMetaFields());
    }

    public HoodieMergeHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> hoodieTable, Map<String, HoodieRecord<T>> keyToNewRecords, String partitionPath, String fileId, HoodieBaseFile dataFileToBeMerged, TaskContextSupplier taskContextSupplier, Option<BaseKeyGenerator> keyGeneratorOpt) {
        super(config, instantTime, partitionPath, fileId, hoodieTable, taskContextSupplier);
        this.keyToNewRecords = keyToNewRecords;
        this.useWriterSchemaForCompaction = true;
        this.preserveMetadata = !HoodieTableMetadata.isMetadataTable(config.getBasePath());
        this.init(fileId, this.partitionPath, dataFileToBeMerged);
        this.validateAndSetAndKeyGenProps(keyGeneratorOpt, config.populateMetaFields());
    }

    private void validateAndSetAndKeyGenProps(Option<BaseKeyGenerator> keyGeneratorOpt, boolean populateMetaFields) {
        ValidationUtils.checkArgument(populateMetaFields == !keyGeneratorOpt.isPresent());
        this.keyGeneratorOpt = keyGeneratorOpt;
    }

    public static HoodieBaseFile getLatestBaseFile(HoodieTable<?, ?, ?, ?> hoodieTable, String partitionPath, String fileId) {
        Option<HoodieBaseFile> baseFileOp = hoodieTable.getBaseFileOnlyView().getLatestBaseFile(partitionPath, fileId);
        if (!baseFileOp.isPresent()) {
            throw new NoSuchElementException(String.format("FileID %s of partition path %s does not exist.", fileId, partitionPath));
        }
        return baseFileOp.get();
    }

    private void init(String fileId, String partitionPath, HoodieBaseFile baseFileToMerge) {
        LOG.info("partitionPath:" + partitionPath + ", fileId to be merged:" + fileId);
        this.baseFileToMerge = baseFileToMerge;
        this.writtenRecordKeys = new HashSet<String>();
        this.writeStatus.setStat(new HoodieWriteStat());
        try {
            String latestValidFilePath = baseFileToMerge.getFileName();
            this.writeStatus.getStat().setPrevCommit(baseFileToMerge.getCommitTime());
            HoodiePartitionMetadata partitionMetadata = new HoodiePartitionMetadata(this.fs, this.instantTime, new Path(this.config.getBasePath()), FSUtils.getPartitionPath(this.config.getBasePath(), partitionPath), this.hoodieTable.getPartitionMetafileFormat());
            partitionMetadata.trySave(this.getPartitionId());
            String newFileName = FSUtils.makeBaseFileName(this.instantTime, this.writeToken, fileId, this.hoodieTable.getBaseFileExtension());
            this.makeOldAndNewFilePaths(partitionPath, latestValidFilePath, newFileName);
            LOG.info(String.format("Merging new data into oldPath %s, as newPath %s", this.oldFilePath.toString(), this.newFilePath.toString()));
            this.writeStatus.setFileId(fileId);
            this.writeStatus.setPartitionPath(partitionPath);
            this.writeStatus.getStat().setPartitionPath(partitionPath);
            this.writeStatus.getStat().setFileId(fileId);
            this.setWriteStatusPath();
            this.createMarkerFile(partitionPath, this.newFilePath.getName());
            this.fileWriter = HoodieFileWriterFactory.getFileWriter(this.instantTime, this.newFilePath, this.hoodieTable.getHadoopConf(), this.config, this.writeSchemaWithMetaFields, this.taskContextSupplier, this.recordMerger.getRecordType());
        }
        catch (IOException io) {
            LOG.error("Error in update task at commit " + this.instantTime, (Throwable)io);
            this.writeStatus.setGlobalError(io);
            throw new HoodieUpsertException("Failed to initialize HoodieUpdateHandle for FileId: " + fileId + " on commit " + this.instantTime + " on path " + this.hoodieTable.getMetaClient().getBasePath(), io);
        }
    }

    protected void setWriteStatusPath() {
        this.writeStatus.getStat().setPath(new Path(this.config.getBasePath()), this.newFilePath);
    }

    protected void makeOldAndNewFilePaths(String partitionPath, String oldFileName, String newFileName) {
        this.oldFilePath = this.makeNewFilePath(partitionPath, oldFileName);
        this.newFilePath = this.makeNewFilePath(partitionPath, newFileName);
    }

    protected void initializeIncomingRecordsMap() {
        try {
            long memoryForMerge = IOUtils.getMaxMemoryPerPartitionMerge(this.taskContextSupplier, this.config);
            LOG.info("MaxMemoryPerPartitionMerge => " + memoryForMerge);
            this.keyToNewRecords = new ExternalSpillableMap<String, String>(memoryForMerge, this.config.getSpillableMapBasePath(), new DefaultSizeEstimator(), new HoodieRecordSizeEstimator(this.writeSchema), this.config.getCommonConfig().getSpillableDiskMapType(), this.config.getCommonConfig().isBitCaskDiskMapCompressionEnabled());
        }
        catch (IOException io) {
            throw new HoodieIOException("Cannot instantiate an ExternalSpillableMap", io);
        }
    }

    boolean needsUpdateLocation() {
        return true;
    }

    protected void init(String fileId, Iterator<HoodieRecord<T>> newRecordsItr) {
        this.initializeIncomingRecordsMap();
        while (newRecordsItr.hasNext()) {
            HoodieRecord<T> record = newRecordsItr.next();
            if (this.needsUpdateLocation()) {
                record.unseal();
                record.setNewLocation(new HoodieRecordLocation(this.instantTime, fileId));
                record.seal();
            }
            this.keyToNewRecords.put(record.getRecordKey(), record);
        }
        LOG.info("Number of entries in MemoryBasedMap => " + ((ExternalSpillableMap)this.keyToNewRecords).getInMemoryMapNumEntries() + ", Total size in bytes of MemoryBasedMap => " + ((ExternalSpillableMap)this.keyToNewRecords).getCurrentInMemoryMapSize() + ", Number of entries in BitCaskDiskMap => " + ((ExternalSpillableMap)this.keyToNewRecords).getDiskBasedMapNumEntries() + ", Size of file spilled to disk => " + ((ExternalSpillableMap)this.keyToNewRecords).getSizeOfFileOnDiskInBytes());
    }

    protected boolean writeUpdateRecord(HoodieRecord<T> newRecord, HoodieRecord<T> oldRecord, Option<HoodieRecord> combineRecordOpt, Schema writerSchema) throws IOException {
        boolean isDelete = false;
        if (combineRecordOpt.isPresent()) {
            if (oldRecord.getData() == combineRecordOpt.get().getData()) {
                return false;
            }
            isDelete = HoodieOperation.isDelete(newRecord.getOperation());
            ++this.updatedRecordsWritten;
        }
        return this.writeRecord(newRecord, combineRecordOpt, writerSchema, this.config.getPayloadConfig().getProps(), isDelete);
    }

    protected void writeInsertRecord(HoodieRecord<T> newRecord) throws IOException {
        Schema schema;
        Schema schema2 = schema = this.useWriterSchemaForCompaction ? this.writeSchemaWithMetaFields : this.writeSchema;
        if (newRecord.shouldIgnore(schema, this.config.getProps())) {
            return;
        }
        this.writeInsertRecord(newRecord, schema, this.config.getProps());
    }

    protected void writeInsertRecord(HoodieRecord<T> newRecord, Schema schema, Properties prop) throws IOException {
        if (this.writeRecord(newRecord, Option.of(newRecord), schema, prop, HoodieOperation.isDelete(newRecord.getOperation()))) {
            ++this.insertRecordsWritten;
        }
    }

    protected boolean writeRecord(HoodieRecord<T> newRecord, Option<HoodieRecord> combineRecord, Schema schema, Properties prop) throws IOException {
        return this.writeRecord(newRecord, combineRecord, schema, prop, false);
    }

    private boolean writeRecord(HoodieRecord<T> newRecord, Option<HoodieRecord> combineRecord, Schema schema, Properties prop, boolean isDelete) throws IOException {
        Option<Map<String, String>> recordMetadata = newRecord.getMetadata();
        if (!this.partitionPath.equals(newRecord.getPartitionPath())) {
            HoodieUpsertException failureEx = new HoodieUpsertException("mismatched partition path, record partition: " + newRecord.getPartitionPath() + " but trying to insert into partition: " + this.partitionPath);
            this.writeStatus.markFailure(newRecord, failureEx, recordMetadata);
            return false;
        }
        try {
            if (combineRecord.isPresent() && !combineRecord.get().isDelete(schema, this.config.getProps()) && !isDelete) {
                this.writeToFile(newRecord.getKey(), combineRecord.get(), schema, prop, this.preserveMetadata && this.useWriterSchemaForCompaction);
                ++this.recordsWritten;
            } else {
                ++this.recordsDeleted;
                newRecord.unseal();
                newRecord.clearNewLocation();
                newRecord.seal();
            }
            this.writeStatus.markSuccess(newRecord, recordMetadata);
            newRecord.deflate();
            return true;
        }
        catch (Exception e) {
            LOG.error("Error writing record  " + newRecord, (Throwable)e);
            this.writeStatus.markFailure(newRecord, e, recordMetadata);
            return false;
        }
    }

    public void write(HoodieRecord<T> oldRecord) {
        Schema oldSchema = this.config.populateMetaFields() ? this.writeSchemaWithMetaFields : this.writeSchema;
        Schema newSchema = this.useWriterSchemaForCompaction ? this.writeSchemaWithMetaFields : this.writeSchema;
        boolean copyOldRecord = true;
        String key = oldRecord.getRecordKey(oldSchema, this.keyGeneratorOpt);
        TypedProperties props = this.config.getPayloadConfig().getProps();
        if (this.keyToNewRecords.containsKey(key)) {
            HoodieRecord<T> newRecord = this.keyToNewRecords.get(key).newInstance();
            try {
                Option<Pair<HoodieRecord, Schema>> mergeResult = this.recordMerger.merge(oldRecord, oldSchema, newRecord, newSchema, props);
                Schema combineRecordSchema = mergeResult.map(Pair::getRight).orElse(null);
                Option<HoodieRecord> combinedRecord = mergeResult.map(Pair::getLeft);
                if (combinedRecord.isPresent() && combinedRecord.get().shouldIgnore(combineRecordSchema, props)) {
                    copyOldRecord = true;
                } else if (this.writeUpdateRecord(newRecord, oldRecord, combinedRecord, combineRecordSchema)) {
                    copyOldRecord = false;
                }
                this.writtenRecordKeys.add(key);
            }
            catch (Exception e) {
                throw new HoodieUpsertException("Failed to combine/merge new record with old value in storage, for new record {" + this.keyToNewRecords.get(key) + "}, old value {" + oldRecord + "}", e);
            }
        }
        if (copyOldRecord) {
            try {
                this.writeToFile(new HoodieKey(key, this.partitionPath), oldRecord, oldSchema, props, true);
            }
            catch (IOException | RuntimeException e) {
                String errMsg = String.format("Failed to merge old record into new file for key %s from old file %s to new file %s with writerSchema %s", key, this.getOldFilePath(), this.newFilePath, this.writeSchemaWithMetaFields.toString(true));
                LOG.debug("Old record is " + oldRecord);
                throw new HoodieUpsertException(errMsg, e);
            }
            ++this.recordsWritten;
        }
    }

    protected void writeToFile(HoodieKey key, HoodieRecord<T> record, Schema schema, Properties prop, boolean shouldPreserveRecordMetadata) throws IOException {
        MetadataValues metadataValues = new MetadataValues().setFileName(this.newFilePath.getName());
        HoodieRecord populatedRecord = record.prependMetaFields(schema, this.writeSchemaWithMetaFields, metadataValues, prop);
        if (shouldPreserveRecordMetadata) {
            this.fileWriter.write(key.getRecordKey(), populatedRecord, this.writeSchemaWithMetaFields);
        } else {
            this.fileWriter.writeWithMetadata(key, populatedRecord, this.writeSchemaWithMetaFields);
        }
    }

    protected void writeIncomingRecords() throws IOException {
        Iterator<Object> newRecordsItr;
        Iterator<Object> iterator2 = newRecordsItr = this.keyToNewRecords instanceof ExternalSpillableMap ? ((ExternalSpillableMap)this.keyToNewRecords).iterator() : this.keyToNewRecords.values().iterator();
        while (newRecordsItr.hasNext()) {
            HoodieRecord hoodieRecord = (HoodieRecord)newRecordsItr.next();
            if (this.writtenRecordKeys.contains(hoodieRecord.getRecordKey())) continue;
            this.writeInsertRecord(hoodieRecord);
        }
    }

    @Override
    public List<WriteStatus> close() {
        try {
            if (this.isClosed()) {
                return Collections.emptyList();
            }
            this.markClosed();
            this.writeIncomingRecords();
            if (this.keyToNewRecords instanceof ExternalSpillableMap) {
                ((ExternalSpillableMap)this.keyToNewRecords).close();
            }
            this.keyToNewRecords = null;
            this.writtenRecordKeys = null;
            this.fileWriter.close();
            this.fileWriter = null;
            long fileSizeInBytes = FSUtils.getFileSize(this.fs, this.newFilePath);
            HoodieWriteStat stat = this.writeStatus.getStat();
            stat.setTotalWriteBytes(fileSizeInBytes);
            stat.setFileSizeInBytes(fileSizeInBytes);
            stat.setNumWrites(this.recordsWritten);
            stat.setNumDeletes(this.recordsDeleted);
            stat.setNumUpdateWrites(this.updatedRecordsWritten);
            stat.setNumInserts(this.insertRecordsWritten);
            stat.setTotalWriteErrors(this.writeStatus.getTotalErrorRecords());
            HoodieWriteStat.RuntimeStats runtimeStats = new HoodieWriteStat.RuntimeStats();
            runtimeStats.setTotalUpsertTime(this.timer.endTimer());
            stat.setRuntimeStats(runtimeStats);
            this.performMergeDataValidationCheck(this.writeStatus);
            LOG.info(String.format("MergeHandle for partitionPath %s fileID %s, took %d ms.", stat.getPartitionPath(), stat.getFileId(), runtimeStats.getTotalUpsertTime()));
            return Collections.singletonList(this.writeStatus);
        }
        catch (IOException e) {
            throw new HoodieUpsertException("Failed to close UpdateHandle", e);
        }
    }

    public void performMergeDataValidationCheck(WriteStatus writeStatus) {
        if (!this.config.isMergeDataValidationCheckEnabled()) {
            return;
        }
        long oldNumWrites = 0L;
        try (HoodieFileReader reader = HoodieFileReaderFactory.getReaderFactory(this.recordMerger.getRecordType()).getFileReader(this.hoodieTable.getHadoopConf(), this.oldFilePath);){
            oldNumWrites = reader.getTotalRecords();
        }
        catch (IOException e) {
            throw new HoodieUpsertException("Failed to check for merge data validation", e);
        }
        if (writeStatus.getStat().getNumWrites() + writeStatus.getStat().getNumDeletes() < oldNumWrites) {
            throw new HoodieCorruptedDataException(String.format("Record write count decreased for file: %s, Partition Path: %s (%s:%d + %d < %s:%d)", writeStatus.getFileId(), writeStatus.getPartitionPath(), this.instantTime, writeStatus.getStat().getNumWrites(), writeStatus.getStat().getNumDeletes(), this.baseFileToMerge.getCommitTime(), oldNumWrites));
        }
    }

    public Path getOldFilePath() {
        return this.oldFilePath;
    }

    @Override
    public IOType getIOType() {
        return IOType.MERGE;
    }

    public HoodieBaseFile baseFileForMerge() {
        return this.baseFileToMerge;
    }

    public void setPartitionFields(Option<String[]> partitionFields) {
        this.partitionFields = partitionFields;
    }

    public Option<String[]> getPartitionFields() {
        return this.partitionFields;
    }

    public void setPartitionValues(Object[] partitionValues) {
        this.partitionValues = partitionValues;
    }

    public Object[] getPartitionValues() {
        return this.partitionValues;
    }
}

