/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.metadata.HoodieTableMetadata;

public class HoodieMetadataFileSystemView
extends HoodieTableFileSystemView {
    private final HoodieTableMetadata tableMetadata;

    public HoodieMetadataFileSystemView(HoodieTableMetaClient metaClient, HoodieTimeline visibleActiveTimeline, HoodieTableMetadata tableMetadata) {
        super(metaClient, visibleActiveTimeline);
        this.tableMetadata = tableMetadata;
    }

    public HoodieMetadataFileSystemView(HoodieEngineContext engineContext, HoodieTableMetaClient metaClient, HoodieTimeline visibleActiveTimeline, HoodieMetadataConfig metadataConfig) {
        this(metaClient, visibleActiveTimeline, HoodieTableMetadata.create(engineContext, metadataConfig, metaClient.getBasePath(), true));
    }

    @Override
    protected FileStatus[] listPartition(Path partitionPath) throws IOException {
        return this.tableMetadata.getAllFilesInPartition(partitionPath);
    }

    @Override
    protected List<String> getAllPartitionPaths() throws IOException {
        return this.tableMetadata.getAllPartitionPaths();
    }

    @Override
    protected Map<Pair<String, Path>, FileStatus[]> listPartitions(List<Pair<String, Path>> partitionPathList) throws IOException {
        Map absoluteToPairMap = partitionPathList.stream().collect(Collectors.toMap(pair -> ((Path)pair.getRight()).toString(), Function.identity()));
        return this.tableMetadata.getAllFilesInPartitions(partitionPathList.stream().map(pair -> ((Path)pair.getRight()).toString()).collect(Collectors.toList())).entrySet().stream().collect(Collectors.toMap(entry -> (Pair)absoluteToPairMap.get(entry.getKey()), Map.Entry::getValue));
    }

    @Override
    public void reset() {
        try {
            this.writeLock.lock();
            this.clear();
            this.init(this.metaClient, this.getTimeline());
            this.tableMetadata.reset();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void sync() {
        try {
            this.writeLock.lock();
            this.maySyncIncrementally();
            this.tableMetadata.reset();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void close() {
        try {
            this.tableMetadata.close();
        }
        catch (Exception e) {
            throw new HoodieException("Error closing metadata file system view.", e);
        }
    }
}

