/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics;

import com.codahale.metrics.MetricRegistry;
import java.util.Properties;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.metrics.ConsoleMetricsReporter;
import org.apache.hudi.metrics.InMemoryMetricsReporter;
import org.apache.hudi.metrics.JmxMetricsReporter;
import org.apache.hudi.metrics.MetricsGraphiteReporter;
import org.apache.hudi.metrics.MetricsReporter;
import org.apache.hudi.metrics.MetricsReporterType;
import org.apache.hudi.metrics.cloudwatch.CloudWatchMetricsReporter;
import org.apache.hudi.metrics.custom.CustomizableMetricsReporter;
import org.apache.hudi.metrics.datadog.DatadogMetricsReporter;
import org.apache.hudi.metrics.prometheus.PrometheusReporter;
import org.apache.hudi.metrics.prometheus.PushGatewayMetricsReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsReporterFactory {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsReporterFactory.class);

    public static Option<MetricsReporter> createReporter(HoodieWriteConfig config, MetricRegistry registry) {
        String reporterClassName = config.getMetricReporterClassName();
        if (!StringUtils.isNullOrEmpty(reporterClassName)) {
            Object instance = ReflectionUtils.loadClass(reporterClassName, new Class[]{Properties.class, MetricRegistry.class}, new Object[]{config.getProps(), registry});
            if (!(instance instanceof CustomizableMetricsReporter)) {
                throw new HoodieException(config.getMetricReporterClassName() + " is not a subclass of CustomizableMetricsReporter");
            }
            return Option.of((MetricsReporter)instance);
        }
        MetricsReporterType type = config.getMetricsReporterType();
        MetricsReporter reporter = null;
        if (type == null) {
            LOG.warn(String.format("Metric creation failed. %s is not configured", HoodieMetricsConfig.METRICS_REPORTER_TYPE_VALUE.key()));
            return Option.empty();
        }
        switch (type) {
            case GRAPHITE: {
                reporter = new MetricsGraphiteReporter(config, registry);
                break;
            }
            case INMEMORY: {
                reporter = new InMemoryMetricsReporter();
                break;
            }
            case JMX: {
                reporter = new JmxMetricsReporter(config, registry);
                break;
            }
            case DATADOG: {
                reporter = new DatadogMetricsReporter(config, registry);
                break;
            }
            case PROMETHEUS_PUSHGATEWAY: {
                reporter = new PushGatewayMetricsReporter(config, registry);
                break;
            }
            case PROMETHEUS: {
                reporter = new PrometheusReporter(config, registry);
                break;
            }
            case CONSOLE: {
                reporter = new ConsoleMetricsReporter(registry);
                break;
            }
            case CLOUDWATCH: {
                reporter = new CloudWatchMetricsReporter(config, registry);
                break;
            }
            default: {
                LOG.error("Reporter type[" + (Object)((Object)type) + "] is not supported.");
            }
        }
        return Option.ofNullable(reporter);
    }
}

