/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.parquet.io;

import org.apache.hudi.common.util.io.ByteBufferBackedInputStream;
import org.apache.parquet.io.DelegatingSeekableInputStream;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.SeekableInputStream;

public class ByteBufferBackedInputFile
implements InputFile {
    private final byte[] buffer;
    private final int offset;
    private final int length;

    public ByteBufferBackedInputFile(byte[] buffer, int offset, int length) {
        this.buffer = buffer;
        this.offset = offset;
        this.length = length;
    }

    public long getLength() {
        return this.length;
    }

    public SeekableInputStream newStream() {
        return new DelegatingSeekableInputStream(new ByteBufferBackedInputStream(this.buffer, this.offset, this.length)){

            public long getPos() {
                return ((ByteBufferBackedInputStream)this.getStream()).getPosition();
            }

            public void seek(long newPos) {
                ((ByteBufferBackedInputStream)this.getStream()).seek(newPos);
            }
        };
    }
}

