/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.utils;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import javax.annotation.Nullable;
import org.apache.avro.generic.GenericRecord;
import org.apache.flink.configuration.Configuration;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.BaseAvroPayload;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.configuration.OptionsResolver;

public class PayloadCreation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean shouldCombine;
    private final Constructor<?> constructor;
    private final String preCombineField;

    private PayloadCreation(boolean shouldCombine, Constructor<?> constructor, @Nullable String preCombineField) {
        this.shouldCombine = shouldCombine;
        this.constructor = constructor;
        this.preCombineField = preCombineField;
    }

    public static PayloadCreation instance(Configuration conf) throws Exception {
        String preCombineField = OptionsResolver.getPreCombineField(conf);
        boolean needCombine = conf.getBoolean(FlinkOptions.PRE_COMBINE) || WriteOperationType.fromValue(conf.getString(FlinkOptions.OPERATION)) == WriteOperationType.UPSERT;
        boolean shouldCombine = needCombine && preCombineField != null;
        Class[] argTypes = shouldCombine ? new Class[]{GenericRecord.class, Comparable.class} : new Class[]{Option.class};
        String clazz = conf.getString(FlinkOptions.PAYLOAD_CLASS_NAME);
        Constructor<?> constructor = ReflectionUtils.getClass(clazz).getConstructor(argTypes);
        return new PayloadCreation(shouldCombine, constructor, preCombineField);
    }

    public HoodieRecordPayload<?> createPayload(GenericRecord record) throws Exception {
        if (this.shouldCombine) {
            ValidationUtils.checkState(this.preCombineField != null);
            Comparable orderingVal = (Comparable)HoodieAvroUtils.getNestedFieldVal(record, this.preCombineField, false, false);
            return (HoodieRecordPayload)this.constructor.newInstance(record, orderingVal);
        }
        return (HoodieRecordPayload)this.constructor.newInstance(Option.of(record));
    }

    public HoodieRecordPayload<?> createDeletePayload(BaseAvroPayload payload) throws Exception {
        if (this.shouldCombine) {
            return (HoodieRecordPayload)this.constructor.newInstance(null, payload.getOrderingVal());
        }
        return (HoodieRecordPayload)this.constructor.newInstance(Option.empty());
    }
}

