/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.source.stats;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.generic.GenericRecord;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hudi.avro.model.HoodieMetadataRecord;
import org.apache.hudi.client.common.HoodieFlinkEngineContext;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.common.util.collection.Tuple3;
import org.apache.hudi.common.util.hash.ColumnIndexID;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.util.AvroSchemaConverter;
import org.apache.hudi.util.AvroToRowDataConverters;
import org.apache.hudi.util.RowDataProjection;

public class ColumnStatsIndices {
    private static final DataType METADATA_DATA_TYPE = ColumnStatsIndices.getMetadataDataType();
    private static final DataType COL_STATS_DATA_TYPE = ColumnStatsIndices.getColStatsDataType();
    private static final int[] COL_STATS_TARGET_POS = ColumnStatsIndices.getColStatsTargetPos();
    private static final int ORD_FILE_NAME = 0;
    private static final int ORD_MIN_VAL = 1;
    private static final int ORD_MAX_VAL = 2;
    private static final int ORD_NULL_CNT = 3;
    private static final int ORD_VAL_CNT = 4;
    private static final int ORD_COL_NAME = 5;

    private ColumnStatsIndices() {
    }

    public static List<RowData> readColumnStatsIndex(String basePath, HoodieMetadataConfig metadataConfig, String[] targetColumns) {
        ValidationUtils.checkArgument(targetColumns.length > 0, "Column stats is only valid when push down filters have referenced columns");
        List<RowData> metadataRows = ColumnStatsIndices.readColumnStatsIndexByColumns(basePath, targetColumns, metadataConfig);
        return ColumnStatsIndices.projectNestedColStatsColumns(metadataRows);
    }

    private static List<RowData> projectNestedColStatsColumns(List<RowData> rows) {
        int pos = HoodieMetadataRecord.SCHEMA$.getField("ColumnStatsMetadata").pos();
        RowDataProjection projection = RowDataProjection.instanceV2((RowType)COL_STATS_DATA_TYPE.getLogicalType(), COL_STATS_TARGET_POS);
        return ((Stream)rows.stream().parallel()).map(row -> {
            RowData columnStatsField = row.getRow(pos, 9);
            return projection.project(columnStatsField);
        }).collect(Collectors.toList());
    }

    public static Pair<List<RowData>, String[]> transposeColumnStatsIndex(List<RowData> colStats, String[] queryColumns, RowType tableSchema) {
        Map<String, LogicalType> tableFieldTypeMap = tableSchema.getFields().stream().collect(Collectors.toMap(RowType.RowField::getName, RowType.RowField::getType));
        Set indexedColumns = colStats.stream().map(row -> row.getString(5).toString()).collect(Collectors.toSet());
        TreeSet sortedTargetColumns = Arrays.stream(queryColumns).sorted().filter(indexedColumns::contains).collect(Collectors.toCollection(TreeSet::new));
        ConcurrentHashMap converters2 = new ConcurrentHashMap();
        Map<StringData, List<RowData>> fileNameToRows = ((Stream)colStats.stream().parallel()).filter(row -> sortedTargetColumns.contains(row.getString(5).toString())).map(row -> {
            if (row.isNullAt(1) && row.isNullAt(2)) {
                return row;
            }
            String colName = row.getString(5).toString();
            LogicalType colType = (LogicalType)tableFieldTypeMap.get(colName);
            return ColumnStatsIndices.unpackMinMaxVal(row, colType, converters2);
        }).collect(Collectors.groupingBy(rowData -> rowData.getString(0)));
        return Pair.of(ColumnStatsIndices.foldRowsByFiles(sortedTargetColumns, fileNameToRows), sortedTargetColumns.toArray(new String[0]));
    }

    private static List<RowData> foldRowsByFiles(TreeSet<String> sortedTargetColumns, Map<StringData, List<RowData>> fileNameToRows) {
        return ((Stream)fileNameToRows.values().stream().parallel()).map(rows -> {
            StringData fileName = ((RowData)rows.get(0)).getString(0);
            long valueCount = ((RowData)rows.get(0)).getLong(4);
            Map<String, RowData> columnRowsMap = rows.stream().collect(Collectors.toMap(row -> row.getString(5).toString(), row -> row));
            TreeMap alignedColumnRowsMap = new TreeMap();
            sortedTargetColumns.forEach(col -> {
                RowData cfr_ignored_0 = (RowData)alignedColumnRowsMap.put(col, columnRowsMap.get(col));
            });
            List columnStats = alignedColumnRowsMap.values().stream().map(row -> {
                if (row == null) {
                    return Tuple3.of(null, null, valueCount);
                }
                GenericRowData gr = (GenericRowData)row;
                return Tuple3.of(gr.getField(1), gr.getField(2), gr.getField(3));
            }).collect(Collectors.toList());
            GenericRowData foldedRow = new GenericRowData(2 + 3 * columnStats.size());
            foldedRow.setField(0, (Object)fileName);
            foldedRow.setField(1, (Object)valueCount);
            for (int i = 0; i < columnStats.size(); ++i) {
                Tuple3 stats = (Tuple3)columnStats.get(i);
                int startPos = 2 + 3 * i;
                foldedRow.setField(startPos, stats.f0);
                foldedRow.setField(startPos + 1, stats.f1);
                foldedRow.setField(startPos + 2, stats.f2);
            }
            return foldedRow;
        }).collect(Collectors.toList());
    }

    private static RowData unpackMinMaxVal(RowData row, LogicalType colType, Map<LogicalType, AvroToRowDataConverters.AvroToRowDataConverter> converters2) {
        RowData minValueStruct = row.getRow(1, 1);
        RowData maxValueStruct = row.getRow(2, 1);
        ValidationUtils.checkState(minValueStruct != null && maxValueStruct != null, "Invalid Column Stats record: either both min/max have to be null, or both have to be non-null");
        Object minValue = ColumnStatsIndices.tryUnpackNonNullVal(minValueStruct, colType, converters2);
        Object maxValue = ColumnStatsIndices.tryUnpackNonNullVal(maxValueStruct, colType, converters2);
        GenericRowData unpackedRow = new GenericRowData(row.getArity());
        unpackedRow.setField(0, (Object)row.getString(0));
        unpackedRow.setField(1, minValue);
        unpackedRow.setField(2, maxValue);
        unpackedRow.setField(3, (Object)row.getLong(3));
        unpackedRow.setField(4, (Object)row.getLong(4));
        unpackedRow.setField(5, (Object)row.getString(5));
        return unpackedRow;
    }

    private static Object tryUnpackNonNullVal(RowData rowData, LogicalType colType, Map<LogicalType, AvroToRowDataConverters.AvroToRowDataConverter> converters2) {
        for (int i = 0; i < rowData.getArity(); ++i) {
            Object nested = ((GenericRowData)rowData).getField(i);
            if (nested == null) continue;
            return ColumnStatsIndices.doUnpack(nested, colType, converters2);
        }
        return null;
    }

    private static Object doUnpack(Object rawVal, LogicalType logicalType, Map<LogicalType, AvroToRowDataConverters.AvroToRowDataConverter> converters2) {
        AvroToRowDataConverters.AvroToRowDataConverter converter = converters2.computeIfAbsent(logicalType, k -> AvroToRowDataConverters.createConverter(logicalType));
        return converter.convert(rawVal);
    }

    private static List<RowData> readColumnStatsIndexByColumns(String basePath, String[] targetColumns, HoodieMetadataConfig metadataConfig) {
        HoodieTableMetadata metadataTable = HoodieTableMetadata.create(HoodieFlinkEngineContext.DEFAULT, metadataConfig, basePath);
        List<String> encodedTargetColumnNames = Arrays.stream(targetColumns).map(colName -> new ColumnIndexID((String)colName).asBase64EncodedString()).collect(Collectors.toList());
        HoodieData<HoodieRecord<HoodieMetadataPayload>> records = metadataTable.getRecordsByKeyPrefixes(encodedTargetColumnNames, "column_stats", false);
        AvroToRowDataConverters.AvroToRowDataConverter converter = AvroToRowDataConverters.createRowConverter((RowType)METADATA_DATA_TYPE.getLogicalType());
        return ((Stream)records.collectAsList().stream().parallel()).map(record -> {
            GenericRecord genericRecord;
            try {
                genericRecord = ((HoodieMetadataPayload)record.getData()).getInsertValue(null, null).orElse(null);
            }
            catch (IOException e) {
                throw new HoodieException("Exception while getting insert value from metadata payload");
            }
            return (RowData)converter.convert(genericRecord);
        }).collect(Collectors.toList());
    }

    private static DataType getMetadataDataType() {
        return AvroSchemaConverter.convertToDataType(HoodieMetadataRecord.SCHEMA$);
    }

    private static DataType getColStatsDataType() {
        int pos = HoodieMetadataRecord.SCHEMA$.getField("ColumnStatsMetadata").pos();
        return (DataType)METADATA_DATA_TYPE.getChildren().get(pos);
    }

    private static int[] getColStatsTargetPos() {
        RowType colStatsRowType = (RowType)COL_STATS_DATA_TYPE.getLogicalType();
        return Stream.of("fileName", "minValue", "maxValue", "nullCount", "valueCount", "columnName").mapToInt(arg_0 -> ((RowType)colStatsRowType).getFieldIndex(arg_0)).toArray();
    }
}

