/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.table.WorkloadStat;

public class WorkloadProfile
implements Serializable {
    protected final HashMap<String, WorkloadStat> inputPartitionPathStatMap;
    protected final HashMap<String, WorkloadStat> outputPartitionPathStatMap;
    protected final WorkloadStat globalStat;
    private WriteOperationType operationType;
    private final boolean hasOutputWorkLoadStats;

    public WorkloadProfile(Pair<HashMap<String, WorkloadStat>, WorkloadStat> profile) {
        this(profile, false);
    }

    public WorkloadProfile(Pair<HashMap<String, WorkloadStat>, WorkloadStat> profile, boolean hasOutputWorkLoadStats) {
        this.inputPartitionPathStatMap = profile.getLeft();
        this.globalStat = profile.getRight();
        this.outputPartitionPathStatMap = new HashMap();
        this.hasOutputWorkLoadStats = hasOutputWorkLoadStats;
    }

    public WorkloadProfile(Pair<HashMap<String, WorkloadStat>, WorkloadStat> profile, WriteOperationType operationType, boolean hasOutputWorkLoadStats) {
        this(profile, hasOutputWorkLoadStats);
        this.operationType = operationType;
    }

    public WorkloadStat getGlobalStat() {
        return this.globalStat;
    }

    public Set<String> getPartitionPaths() {
        return this.inputPartitionPathStatMap.keySet();
    }

    public Set<String> getOutputPartitionPaths() {
        return this.hasOutputWorkLoadStats ? this.outputPartitionPathStatMap.keySet() : this.inputPartitionPathStatMap.keySet();
    }

    public HashMap<String, WorkloadStat> getInputPartitionPathStatMap() {
        return this.inputPartitionPathStatMap;
    }

    public HashMap<String, WorkloadStat> getOutputPartitionPathStatMap() {
        return this.outputPartitionPathStatMap;
    }

    public boolean hasOutputWorkLoadStats() {
        return this.hasOutputWorkLoadStats;
    }

    public void updateOutputPartitionPathStatMap(String partitionPath, WorkloadStat workloadStat) {
        if (this.hasOutputWorkLoadStats) {
            this.outputPartitionPathStatMap.put(partitionPath, workloadStat);
        }
    }

    public WorkloadStat getWorkloadStat(String partitionPath) {
        return this.inputPartitionPathStatMap.get(partitionPath);
    }

    public WorkloadStat getOutputWorkloadStat(String partitionPath) {
        return this.hasOutputWorkLoadStats ? this.outputPartitionPathStatMap.get(partitionPath) : this.inputPartitionPathStatMap.get(partitionPath);
    }

    public WriteOperationType getOperationType() {
        return this.operationType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WorkloadProfile {");
        sb.append("globalStat=").append(this.globalStat).append(", ");
        sb.append("InputPartitionStat=").append(this.inputPartitionPathStatMap).append(", ");
        sb.append("OutputPartitionStat=").append(this.outputPartitionPathStatMap).append(", ");
        sb.append("operationType=").append((Object)this.operationType);
        sb.append('}');
        return sb.toString();
    }
}

