/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.data.HoodieListData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieOperation;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieUpsertException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.commit.BaseCommitActionExecutor;
import org.apache.hudi.table.action.commit.BaseWriteHelper;

public class FlinkWriteHelper<T, R>
extends BaseWriteHelper<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>, R> {
    private FlinkWriteHelper() {
        super((I ignored) -> -1);
    }

    public static FlinkWriteHelper newInstance() {
        return WriteHelperHolder.FLINK_WRITE_HELPER;
    }

    @Override
    public HoodieWriteMetadata<List<WriteStatus>> write(String instantTime, List<HoodieRecord<T>> inputRecords, HoodieEngineContext context, HoodieTable<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> table, boolean shouldCombine, int configuredShuffleParallelism, BaseCommitActionExecutor<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>, R> executor, WriteOperationType operationType) {
        try {
            Instant lookupBegin = Instant.now();
            Duration indexLookupDuration = Duration.between(lookupBegin, Instant.now());
            HoodieWriteMetadata<List<WriteStatus>> result = executor.execute(inputRecords);
            result.setIndexLookupDuration(indexLookupDuration);
            return result;
        }
        catch (Throwable e) {
            if (e instanceof HoodieUpsertException) {
                throw (HoodieUpsertException)e;
            }
            throw new HoodieUpsertException("Failed to upsert for commit time " + instantTime, e);
        }
    }

    @Override
    protected List<HoodieRecord<T>> tag(List<HoodieRecord<T>> dedupedRecords, HoodieEngineContext context, HoodieTable<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> table) {
        return table.getIndex().tagLocation(HoodieListData.eager(dedupedRecords), context, (HoodieTable)table).collectAsList();
    }

    @Override
    public List<HoodieRecord<T>> deduplicateRecords(List<HoodieRecord<T>> records, HoodieIndex<?, ?> index, int parallelism, String schemaStr, TypedProperties props, HoodieRecordMerger merger) {
        Map<Object, List<HoodieRecord>> keyedRecords = records.stream().collect(Collectors.groupingBy(record -> record.getKey().getRecordKey()));
        Schema schema = new Schema.Parser().parse(schemaStr);
        return keyedRecords.values().stream().map(x -> x.stream().reduce((rec1, rec2) -> {
            HoodieRecord reducedRecord;
            try {
                reducedRecord = merger.merge((HoodieRecord)rec1, schema, (HoodieRecord)rec2, schema, props).get().getLeft();
            }
            catch (IOException e) {
                throw new HoodieException(String.format("Error to merge two records, %s, %s", rec1, rec2), e);
            }
            boolean choosePrev = rec1.getData() == reducedRecord.getData();
            HoodieKey reducedKey = choosePrev ? rec1.getKey() : rec2.getKey();
            HoodieOperation operation = choosePrev ? rec1.getOperation() : rec2.getOperation();
            HoodieRecord hoodieRecord = reducedRecord.newInstance(reducedKey, operation);
            hoodieRecord.setCurrentLocation(rec1.getCurrentLocation());
            return hoodieRecord;
        }).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static class WriteHelperHolder {
        private static final FlinkWriteHelper FLINK_WRITE_HELPER = new FlinkWriteHelper();

        private WriteHelperHolder() {
        }
    }
}

