/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.compact.strategy;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hudi.avro.model.HoodieCompactionOperation;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.client.utils.FileSliceMetricUtils;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.hudi.config.HoodieWriteConfig;

public abstract class CompactionStrategy
implements Serializable {
    public static final String TOTAL_IO_READ_MB = "TOTAL_IO_READ_MB";
    public static final String TOTAL_IO_WRITE_MB = "TOTAL_IO_WRITE_MB";
    public static final String TOTAL_IO_MB = "TOTAL_IO_MB";
    public static final String TOTAL_LOG_FILE_SIZE = "TOTAL_LOG_FILES_SIZE";
    public static final String TOTAL_LOG_FILES = "TOTAL_LOG_FILES";

    public Map<String, Double> captureMetrics(HoodieWriteConfig writeConfig, FileSlice slice) {
        HashMap<String, Double> metrics = new HashMap<String, Double>();
        long defaultMaxParquetFileSize = writeConfig.getParquetMaxFileSize();
        FileSliceMetricUtils.addFileSliceCommonMetrics(Collections.singletonList(slice), metrics, defaultMaxParquetFileSize);
        return metrics;
    }

    public HoodieCompactionPlan generateCompactionPlan(HoodieWriteConfig writeConfig, List<HoodieCompactionOperation> operations, List<HoodieCompactionPlan> pendingCompactionPlans) {
        return HoodieCompactionPlan.newBuilder().setOperations(this.orderAndFilter(writeConfig, operations, pendingCompactionPlans)).setVersion(CompactionUtils.LATEST_COMPACTION_METADATA_VERSION).build();
    }

    public List<HoodieCompactionOperation> orderAndFilter(HoodieWriteConfig writeConfig, List<HoodieCompactionOperation> operations, List<HoodieCompactionPlan> pendingCompactionPlans) {
        return operations;
    }

    public List<String> filterPartitionPaths(HoodieWriteConfig writeConfig, List<String> allPartitionPaths) {
        return allPartitionPaths;
    }
}

