/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.restore;

import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.restore.BaseRestoreActionExecutor;
import org.apache.hudi.table.action.rollback.MergeOnReadRollbackActionExecutor;

public class MergeOnReadRestoreActionExecutor<T, I, K, O>
extends BaseRestoreActionExecutor<T, I, K, O> {
    public MergeOnReadRestoreActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, I, K, O> table, String instantTime, String savepointToRestoreTimestamp) {
        super(context, config, table, instantTime, savepointToRestoreTimestamp);
    }

    @Override
    protected HoodieRollbackMetadata rollbackInstant(HoodieInstant instantToRollback) {
        switch (instantToRollback.getAction()) {
            case "commit": 
            case "deltacommit": 
            case "compaction": 
            case "replacecommit": {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid action name " + instantToRollback.getAction());
            }
        }
        this.table.getMetaClient().reloadActiveTimeline();
        String instantTime = HoodieActiveTimeline.createNewInstantTime();
        this.table.scheduleRollback(this.context, instantTime, instantToRollback, false, false, true);
        this.table.getMetaClient().reloadActiveTimeline();
        MergeOnReadRollbackActionExecutor rollbackActionExecutor = new MergeOnReadRollbackActionExecutor(this.context, this.config, this.table, instantTime, instantToRollback, true, true, false);
        return rollbackActionExecutor.execute();
    }
}

