/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.util;

import java.util.Locale;
import org.apache.avro.Schema;
import org.apache.flink.configuration.Configuration;
import org.apache.hudi.client.HoodieFlinkWriteClient;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.table.HoodieFlinkTable;
import org.apache.hudi.util.StreamerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionUtil {
    private static final Logger LOG = LoggerFactory.getLogger(CompactionUtil.class);

    public static void scheduleCompaction(HoodieTableMetaClient metaClient, HoodieFlinkWriteClient<?> writeClient, boolean deltaTimeCompaction, boolean committed) {
        if (committed) {
            writeClient.scheduleCompaction(Option.empty());
        } else if (deltaTimeCompaction) {
            metaClient.reloadActiveTimeline();
            Option<String> compactionInstantTime = CompactionUtil.getCompactionInstantTime(metaClient);
            if (compactionInstantTime.isPresent()) {
                writeClient.scheduleCompactionAtInstant(compactionInstantTime.get(), Option.empty());
            }
        }
    }

    public static Option<String> getCompactionInstantTime(HoodieTableMetaClient metaClient) {
        Option<HoodieInstant> firstPendingInstant = metaClient.getCommitsTimeline().filterPendingExcludingCompaction().firstInstant();
        Option<HoodieInstant> lastCompleteInstant = metaClient.getActiveTimeline().getWriteTimeline().filterCompletedAndCompactionInstants().lastInstant();
        if (firstPendingInstant.isPresent() && lastCompleteInstant.isPresent()) {
            String firstPendingTimestamp = firstPendingInstant.get().getTimestamp();
            String lastCompleteTimestamp = lastCompleteInstant.get().getTimestamp();
            return StreamerUtil.medianInstantTime(firstPendingTimestamp, lastCompleteTimestamp);
        }
        if (!lastCompleteInstant.isPresent()) {
            LOG.info("No instants to schedule the compaction plan");
            return Option.empty();
        }
        return Option.of(HoodieActiveTimeline.createNewInstantTime());
    }

    public static void setAvroSchema(Configuration conf, HoodieTableMetaClient metaClient) throws Exception {
        TableSchemaResolver tableSchemaResolver = new TableSchemaResolver(metaClient);
        Schema tableAvroSchema = tableSchemaResolver.getTableAvroSchema(false);
        conf.setString(FlinkOptions.SOURCE_AVRO_SCHEMA, tableAvroSchema.toString());
    }

    public static void setAvroSchema(HoodieWriteConfig writeConfig, HoodieTableMetaClient metaClient) throws Exception {
        TableSchemaResolver tableSchemaResolver = new TableSchemaResolver(metaClient);
        Schema tableAvroSchema = tableSchemaResolver.getTableAvroSchema(false);
        writeConfig.setSchema(tableAvroSchema.toString());
    }

    public static void setPreCombineField(Configuration conf, HoodieTableMetaClient metaClient) {
        String preCombineField = metaClient.getTableConfig().getPreCombineField();
        if (preCombineField != null) {
            conf.setString(FlinkOptions.PRECOMBINE_FIELD, preCombineField);
        }
    }

    public static void inferChangelogMode(Configuration conf, HoodieTableMetaClient metaClient) {
        TableSchemaResolver tableSchemaResolver = new TableSchemaResolver(metaClient);
        Schema tableAvroSchema = tableSchemaResolver.getTableAvroSchemaFromDataFile();
        if (tableAvroSchema.getField(HoodieRecord.OPERATION_METADATA_FIELD) != null) {
            conf.setBoolean(FlinkOptions.CHANGELOG_ENABLED, true);
        }
    }

    public static void inferMetadataConf(Configuration conf, HoodieTableMetaClient metaClient) {
        String path = HoodieTableMetadata.getMetadataTableBasePath(conf.getString(FlinkOptions.PATH));
        if (!StreamerUtil.tableExists(path, metaClient.getHadoopConf())) {
            conf.setBoolean(FlinkOptions.METADATA_ENABLED, false);
        }
    }

    public static void rollbackCompaction(HoodieFlinkTable<?> table, String instantTime) {
        HoodieInstant inflightInstant = HoodieTimeline.getCompactionInflightInstant(instantTime);
        if (table.getMetaClient().reloadActiveTimeline().filterPendingCompactionTimeline().containsInstant(inflightInstant)) {
            LOG.warn("Rollback failed compaction instant: [" + instantTime + "]");
            table.rollbackInflightCompaction(inflightInstant);
        }
    }

    public static void rollbackCompaction(HoodieFlinkTable<?> table) {
        HoodieTimeline inflightCompactionTimeline = table.getActiveTimeline().filterPendingCompactionTimeline().filter(instant -> instant.getState() == HoodieInstant.State.INFLIGHT);
        inflightCompactionTimeline.getInstants().forEach(inflightInstant -> {
            LOG.info("Rollback the inflight compaction instant: " + inflightInstant + " for failover");
            table.rollbackInflightCompaction((HoodieInstant)inflightInstant);
            table.getMetaClient().reloadActiveTimeline();
        });
    }

    public static void rollbackEarliestCompaction(HoodieFlinkTable<?> table, Configuration conf) {
        Option<HoodieInstant> earliestInflight = table.getActiveTimeline().filterPendingCompactionTimeline().filter(instant -> instant.getState() == HoodieInstant.State.INFLIGHT).firstInstant();
        if (earliestInflight.isPresent()) {
            HoodieInstant instant2 = earliestInflight.get();
            String currentTime = HoodieActiveTimeline.createNewInstantTime();
            int timeout = conf.getInteger(FlinkOptions.COMPACTION_TIMEOUT_SECONDS);
            if (StreamerUtil.instantTimeDiffSeconds(currentTime, instant2.getTimestamp()) >= (long)timeout) {
                LOG.info("Rollback the inflight compaction instant: " + instant2 + " for timeout(" + timeout + "s)");
                table.rollbackInflightCompaction(instant2);
                table.getMetaClient().reloadActiveTimeline();
            }
        }
    }

    public static boolean isLIFO(String seq) {
        return seq.toUpperCase(Locale.ROOT).equals("LIFO");
    }
}

