/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.util;

import java.nio.charset.StandardCharsets;
import org.apache.flink.api.common.functions.AbstractRichFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.formats.common.TimestampFormat;
import org.apache.flink.formats.json.JsonRowDataDeserializationSchema;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hudi.util.AvroSchemaConverter;
import org.apache.hudi.util.StreamerUtil;

public final class JsonDeserializationFunction
extends AbstractRichFunction
implements MapFunction<String, RowData> {
    private final JsonRowDataDeserializationSchema deserializationSchema;

    public static JsonDeserializationFunction getInstance(Configuration conf) {
        RowType rowType = (RowType)AvroSchemaConverter.convertToDataType(StreamerUtil.getSourceSchema(conf)).getLogicalType();
        return JsonDeserializationFunction.getInstance(rowType);
    }

    public static JsonDeserializationFunction getInstance(RowType rowType) {
        JsonRowDataDeserializationSchema deserializationSchema = new JsonRowDataDeserializationSchema(rowType, (TypeInformation)InternalTypeInfo.of((RowType)rowType), false, true, TimestampFormat.ISO_8601);
        return new JsonDeserializationFunction(deserializationSchema);
    }

    public JsonDeserializationFunction(JsonRowDataDeserializationSchema deserializationSchema) {
        this.deserializationSchema = deserializationSchema;
    }

    @Override
    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        this.deserializationSchema.open(null);
    }

    @Override
    public RowData map(String record) throws Exception {
        return this.deserializationSchema.deserialize(record.getBytes(StandardCharsets.UTF_8));
    }
}

