/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.config;

import javax.annotation.concurrent.Immutable;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;

@ConfigClassProperty(name="Cloud Source Configs", groupName=ConfigGroups.Names.HUDI_STREAMER, subGroupName=ConfigGroups.SubGroupNames.DELTA_STREAMER_SOURCE, description="Configs that are common during ingestion across different cloud stores")
@Immutable
public class CloudSourceConfig
extends HoodieConfig {
    public static final ConfigProperty<Integer> BATCH_SIZE_CONF = ConfigProperty.key("hoodie.streamer.source.cloud.meta.batch.size").defaultValue(10).withAlternatives("hoodie.deltastreamer.source.cloud.meta.batch.size").markAdvanced().withDocumentation("Number of metadata messages to pull at a time");
    public static final ConfigProperty<Boolean> ACK_MESSAGES = ConfigProperty.key("hoodie.streamer.source.cloud.meta.ack").defaultValue(true).withAlternatives("hoodie.deltastreamer.source.cloud.meta.ack").markAdvanced().withDocumentation("Whether to acknowledge Metadata messages during Cloud Ingestion or not. This is useful during dev and testing.\n In Prod this should always be true. In case of Cloud Pubsub, not acknowledging means Pubsub will keep redelivering the same messages.");
    public static final ConfigProperty<Boolean> ENABLE_EXISTS_CHECK = ConfigProperty.key("hoodie.streamer.source.cloud.data.check.file.exists").defaultValue(false).withAlternatives("hoodie.deltastreamer.source.cloud.data.check.file.exists").markAdvanced().withDocumentation("If true, checks whether file exists before attempting to pull it");
    public static final ConfigProperty<String> SELECT_RELATIVE_PATH_PREFIX = ConfigProperty.key("hoodie.streamer.source.cloud.data.select.relpath.prefix").noDefaultValue().withAlternatives("hoodie.deltastreamer.source.cloud.data.select.relpath.prefix").markAdvanced().withDocumentation("Only selects objects in the bucket whose relative path matches this prefix");
    public static final ConfigProperty<String> IGNORE_RELATIVE_PATH_PREFIX = ConfigProperty.key("hoodie.streamer.source.cloud.data.ignore.relpath.prefix").noDefaultValue().withAlternatives("hoodie.deltastreamer.source.cloud.data.ignore.relpath.prefix").markAdvanced().withDocumentation("Ignore objects in the bucket whose relative path matches this prefix");
    public static final ConfigProperty<String> IGNORE_RELATIVE_PATH_SUBSTR = ConfigProperty.key("hoodie.streamer.source.cloud.data.ignore.relpath.substring").noDefaultValue().withAlternatives("hoodie.deltastreamer.source.cloud.data.ignore.relpath.substring").markAdvanced().withDocumentation("Ignore objects in the bucket whose relative path contains this substring");
    public static final ConfigProperty<String> SPARK_DATASOURCE_OPTIONS = ConfigProperty.key("hoodie.streamer.source.cloud.data.datasource.options").noDefaultValue().withAlternatives("hoodie.deltastreamer.source.cloud.data.datasource.options").markAdvanced().withDocumentation("A JSON string passed to the Spark DataFrameReader while loading the dataset. Example: hoodie.streamer.gcp.spark.datasource.options={\"header\":\"true\",\"encoding\":\"UTF-8\"}\n");
    public static final ConfigProperty<String> CLOUD_DATAFILE_EXTENSION = ConfigProperty.key("hoodie.streamer.source.cloud.data.select.file.extension").noDefaultValue().withAlternatives("hoodie.deltastreamer.source.cloud.data.select.file.extension").markAdvanced().withDocumentation("Only match files with this extension. By default, this is the same as hoodie.streamer.source.hoodieincr.file.format");
    public static final ConfigProperty<String> DATAFILE_FORMAT = ConfigProperty.key("hoodie.streamer.source.cloud.data.datafile.format").defaultValue("parquet").withAlternatives("hoodie.deltastreamer.source.cloud.data.datafile.format").markAdvanced().withDocumentation("Format of the data file. By default, this will be the same as hoodie.streamer.source.hoodieincr.file.format");
    public static final ConfigProperty<String> PATH_BASED_PARTITION_FIELDS = ConfigProperty.key("hoodie.streamer.source.cloud.data.partition.fields.from.path").noDefaultValue().withAlternatives("hoodie.deltastreamer.source.cloud.data.partition.fields.from.path").markAdvanced().sinceVersion("0.14.0").withDocumentation("A comma delimited list of path-based partition fields in the source file structure.");
}

