/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.config;

import javax.annotation.concurrent.Immutable;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;

@ConfigClassProperty(name="JDBC-based Schema Provider Configs", groupName=ConfigGroups.Names.HUDI_STREAMER, subGroupName=ConfigGroups.SubGroupNames.SCHEMA_PROVIDER, description="Configurations for Proto schema provider.")
@Immutable
public class ProtoClassBasedSchemaProviderConfig
extends HoodieConfig {
    private static final String PROTO_SCHEMA_PROVIDER_PREFIX = "hoodie.streamer.schemaprovider.proto.";
    private static final String OLD_PROTO_SCHEMA_PROVIDER_PREFIX = "hoodie.deltastreamer.schemaprovider.proto.";
    public static final ConfigProperty<String> PROTO_SCHEMA_CLASS_NAME = ConfigProperty.key("hoodie.streamer.schemaprovider.proto.class.name").noDefaultValue().withAlternatives("hoodie.deltastreamer.schemaprovider.proto.class.name").markAdvanced().sinceVersion("0.13.0").withDocumentation("The Protobuf Message class used as the source for the schema.");
    public static final ConfigProperty<Boolean> PROTO_SCHEMA_WRAPPED_PRIMITIVES_AS_RECORDS = ConfigProperty.key("hoodie.streamer.schemaprovider.proto.flatten.wrappers").defaultValue(false).withAlternatives("hoodie.deltastreamer.schemaprovider.proto.flatten.wrappers").markAdvanced().sinceVersion("0.13.0").withDocumentation("When set to true wrapped primitives like Int64Value are translated to a record with a single 'value' field. By default, the value is false and the wrapped primitives are treated as a nullable value");
    public static final ConfigProperty<Boolean> PROTO_SCHEMA_TIMESTAMPS_AS_RECORDS = ConfigProperty.key("hoodie.streamer.schemaprovider.proto.timestamps.as.records").defaultValue(false).withAlternatives("hoodie.deltastreamer.schemaprovider.proto.timestamps.as.records").markAdvanced().sinceVersion("0.13.0").withDocumentation("When set to true Timestamp fields are translated to a record with a seconds and nanos field. By default, the value is false and the timestamp is converted to a long with the timestamp-micros logical type");
    public static final ConfigProperty<Integer> PROTO_SCHEMA_MAX_RECURSION_DEPTH = ConfigProperty.key("hoodie.streamer.schemaprovider.proto.max.recursion.depth").defaultValue(5).withAlternatives("hoodie.deltastreamer.schemaprovider.proto.max.recursion.depth").markAdvanced().sinceVersion("0.13.0").withDocumentation("The max depth to unravel the Proto schema when translating into an Avro schema. Setting this depth allows the user to convert a schema that is recursive in proto into something that can be represented in their lake format like Parquet. After a given class has been seen N times within a single branch, the schema provider will create a record with a byte array to hold the remaining proto data and a string to hold the message descriptor's name for context.");
}

