/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.config;

import javax.annotation.concurrent.Immutable;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;

@ConfigClassProperty(name="Pulsar Source Configs", groupName=ConfigGroups.Names.HUDI_STREAMER, subGroupName=ConfigGroups.SubGroupNames.DELTA_STREAMER_SOURCE, description="Configurations controlling the behavior of Pulsar source in Hudi Streamer.")
@Immutable
public class PulsarSourceConfig
extends HoodieConfig {
    public static final ConfigProperty<Long> PULSAR_SOURCE_MAX_RECORDS_PER_BATCH_THRESHOLD = ConfigProperty.key("hoodie.streamer.source.pulsar.maxRecords").defaultValue(5000000L).withAlternatives("hoodie.deltastreamer.source.pulsar.maxRecords").markAdvanced().withDocumentation("Max number of records obtained in a single each batch");
    public static final ConfigProperty<String> PULSAR_SOURCE_TOPIC_NAME = ConfigProperty.key("hoodie.streamer.source.pulsar.topic").noDefaultValue().withAlternatives("hoodie.deltastreamer.source.pulsar.topic").withDocumentation("Name of the target Pulsar topic to source data from");
    public static final ConfigProperty<String> PULSAR_SOURCE_SERVICE_ENDPOINT_URL = ConfigProperty.key("hoodie.streamer.source.pulsar.endpoint.service.url").defaultValue("pulsar://localhost:6650").withAlternatives("hoodie.deltastreamer.source.pulsar.endpoint.service.url").withDocumentation("URL of the target Pulsar endpoint (of the form 'pulsar://host:port'");
    public static final ConfigProperty<String> PULSAR_SOURCE_ADMIN_ENDPOINT_URL = ConfigProperty.key("hoodie.streamer.source.pulsar.endpoint.admin.url").defaultValue("http://localhost:8080").withAlternatives("hoodie.deltastreamer.source.pulsar.endpoint.admin.url").withDocumentation("URL of the target Pulsar endpoint (of the form 'pulsar://host:port'");
    public static final ConfigProperty<OffsetAutoResetStrategy> PULSAR_SOURCE_OFFSET_AUTO_RESET_STRATEGY = ConfigProperty.key("hoodie.streamer.source.pulsar.offset.autoResetStrategy").defaultValue(OffsetAutoResetStrategy.LATEST).withAlternatives("hoodie.deltastreamer.source.pulsar.offset.autoResetStrategy").markAdvanced().withDocumentation("Policy determining how offsets shall be automatically reset in case there's no checkpoint information present");

    public static enum OffsetAutoResetStrategy {
        LATEST,
        EARLIEST,
        FAIL;

    }
}

