/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.schema.converter;

import io.hops.hudi.com.fasterxml.jackson.databind.JsonNode;
import io.hops.hudi.com.fasterxml.jackson.databind.ObjectMapper;
import io.hops.hudi.com.fasterxml.jackson.databind.node.ArrayNode;
import io.hops.hudi.com.fasterxml.jackson.databind.node.NullNode;
import io.hops.hudi.com.fasterxml.jackson.databind.node.ObjectNode;
import io.hops.hudi.com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.common.util.JsonUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.utilities.schema.SchemaRegistryProvider;

public class JsonToAvroSchemaConverter
implements SchemaRegistryProvider.SchemaConverter {
    private static final ObjectMapper MAPPER = JsonUtils.getObjectMapper();
    private static final Map<String, String> JSON_TO_AVRO_TYPE = Stream.of({"string", "string"}, {"null", "null"}, {"boolean", "boolean"}, {"integer", "long"}, {"number", "double"}).collect(Collectors.collectingAndThen(Collectors.toMap(p -> p[0], p -> p[1]), Collections::unmodifiableMap));
    private static final Pattern SYMBOL_REGEX = Pattern.compile("^[A-Za-z_][A-Za-z0-9_]*$");

    @Override
    public String convert(String jsonSchema) throws IOException {
        JsonNode jsonNode = MAPPER.readTree(jsonSchema);
        ObjectNode avroRecord = MAPPER.createObjectNode().put("type", "record").put("name", JsonToAvroSchemaConverter.getAvroSchemaRecordName(jsonNode)).put("doc", JsonToAvroSchemaConverter.getAvroDoc(jsonNode));
        Option<String> namespace = JsonToAvroSchemaConverter.getAvroSchemaRecordNamespace(jsonNode);
        if (namespace.isPresent()) {
            avroRecord.put("namespace", namespace.get());
        }
        if (jsonNode.hasNonNull("properties")) {
            avroRecord.set("fields", JsonToAvroSchemaConverter.convertProperties(jsonNode.get("properties"), JsonToAvroSchemaConverter.getRequired(jsonNode)));
        } else {
            avroRecord.set("fields", MAPPER.createArrayNode());
        }
        return avroRecord.toString();
    }

    private static ArrayNode convertProperties(JsonNode jsonProperties, Set<String> required) {
        ArrayList avroFields = new ArrayList();
        jsonProperties.fieldNames().forEachRemaining(name -> avroFields.add(JsonToAvroSchemaConverter.tryConvertNestedProperty(name, jsonProperties.get((String)name)).or(JsonToAvroSchemaConverter.tryConvertArrayProperty(name, jsonProperties.get((String)name))).or(JsonToAvroSchemaConverter.tryConvertEnumProperty(name, jsonProperties.get((String)name))).orElse(JsonToAvroSchemaConverter.convertProperty(name, jsonProperties.get((String)name), required.contains(name)))));
        return MAPPER.createArrayNode().addAll(avroFields);
    }

    private static Option<JsonNode> tryConvertNestedProperty(String name, JsonNode jsonProperty) {
        if (!JsonToAvroSchemaConverter.isJsonNestedType(jsonProperty)) {
            return Option.empty();
        }
        Object avroNode = MAPPER.createObjectNode().put("name", JsonToAvroSchemaConverter.sanitizeAsAvroName(name)).put("doc", JsonToAvroSchemaConverter.getAvroDoc(jsonProperty)).set("type", (JsonNode)MAPPER.createObjectNode().put("type", "record").put("name", JsonToAvroSchemaConverter.getAvroTypeName(jsonProperty, name)).set("fields", JsonToAvroSchemaConverter.convertProperties(jsonProperty.get("properties"), JsonToAvroSchemaConverter.getRequired(jsonProperty))));
        return Option.of(avroNode);
    }

    private static Option<JsonNode> tryConvertArrayProperty(String name, JsonNode jsonProperty) {
        if (!JsonToAvroSchemaConverter.isJsonArrayType(jsonProperty)) {
            return Option.empty();
        }
        JsonNode jsonItems = jsonProperty.get("items");
        String itemName = JsonToAvroSchemaConverter.getAvroTypeName(jsonItems, name) + "_child";
        JsonNode avroItems = JsonToAvroSchemaConverter.isJsonNestedType(jsonItems) ? MAPPER.createObjectNode().put("type", "record").put("name", itemName).set("fields", JsonToAvroSchemaConverter.convertProperties(jsonItems.get("properties"), JsonToAvroSchemaConverter.getRequired(jsonItems))) : JsonToAvroSchemaConverter.convertProperty(itemName, jsonItems, true);
        Object avroNode = MAPPER.createObjectNode().put("name", JsonToAvroSchemaConverter.sanitizeAsAvroName(name)).put("doc", JsonToAvroSchemaConverter.getAvroDoc(jsonProperty)).set("type", (JsonNode)MAPPER.createObjectNode().put("type", "array").set("items", avroItems));
        return Option.of(avroNode);
    }

    private static Option<JsonNode> tryConvertEnumProperty(String name, JsonNode jsonProperty) {
        if (!JsonToAvroSchemaConverter.isJsonEnumType(jsonProperty)) {
            return Option.empty();
        }
        ArrayList enums = new ArrayList();
        jsonProperty.get("enum").iterator().forEachRemaining(e -> enums.add(e.asText()));
        TextNode avroType = enums.stream().allMatch(e -> SYMBOL_REGEX.matcher((CharSequence)e).matches()) ? MAPPER.createObjectNode().put("type", "enum").put("name", JsonToAvroSchemaConverter.getAvroTypeName(jsonProperty, name)).set("symbols", jsonProperty.get("enum")) : TextNode.valueOf("string");
        Object avroNode = MAPPER.createObjectNode().put("name", JsonToAvroSchemaConverter.sanitizeAsAvroName(name)).put("doc", JsonToAvroSchemaConverter.getAvroDoc(jsonProperty)).set("type", avroType);
        return Option.of(avroNode);
    }

    private static JsonNode convertProperty(String name, JsonNode jsonProperty, boolean isRequired) {
        boolean nullable;
        ObjectNode avroNode = MAPPER.createObjectNode().put("name", JsonToAvroSchemaConverter.sanitizeAsAvroName(name)).put("doc", JsonToAvroSchemaConverter.getAvroDoc(jsonProperty));
        boolean bl = nullable = !isRequired;
        if (jsonProperty.has("default")) {
            avroNode.set("default", jsonProperty.get("default"));
        } else if (nullable) {
            avroNode.set("default", NullNode.getInstance());
        }
        HashSet<String> avroTypeSet = new HashSet<String>();
        if (jsonProperty.hasNonNull("oneOf") || jsonProperty.hasNonNull("allOf")) {
            Option<JsonNode> allOfTypes;
            Option<JsonNode> oneOfTypes = Option.ofNullable(jsonProperty.get("oneOf"));
            if (oneOfTypes.isPresent()) {
                oneOfTypes.get().elements().forEachRemaining(e -> avroTypeSet.add(JSON_TO_AVRO_TYPE.get(e.get("type").asText())));
            }
            if ((allOfTypes = Option.ofNullable(jsonProperty.get("allOf"))).isPresent()) {
                allOfTypes.get().elements().forEachRemaining(e -> avroTypeSet.add(JSON_TO_AVRO_TYPE.get(e.get("type").asText())));
            }
        } else if (jsonProperty.has("type")) {
            JsonNode jsonType = jsonProperty.get("type");
            if (jsonType.isArray()) {
                jsonType.elements().forEachRemaining(e -> avroTypeSet.add(JSON_TO_AVRO_TYPE.get(e.asText())));
            } else {
                avroTypeSet.add(JSON_TO_AVRO_TYPE.get(jsonType.asText()));
            }
        }
        ArrayList<String> avroTypes = new ArrayList<String>();
        if (nullable || avroTypeSet.contains("null")) {
            avroTypes.add("null");
        }
        avroTypeSet.remove("null");
        avroTypes.addAll(avroTypeSet);
        avroNode.set("type", avroTypes.size() > 1 ? MAPPER.createArrayNode().addAll(avroTypes.stream().map(TextNode::valueOf).collect(Collectors.toList())) : TextNode.valueOf((String)avroTypes.get(0)));
        return avroNode;
    }

    private static boolean isJsonNestedType(JsonNode jsonNode) {
        return jsonNode.has("type") && Objects.equals(jsonNode.get("type").asText(), "object");
    }

    private static boolean isJsonArrayType(JsonNode jsonNode) {
        return jsonNode.has("type") && Objects.equals(jsonNode.get("type").asText(), "array");
    }

    private static boolean isJsonEnumType(JsonNode jsonNode) {
        return jsonNode.hasNonNull("enum") && jsonNode.get("enum").isArray();
    }

    private static Option<String> getAvroSchemaRecordNamespace(JsonNode jsonNode) {
        if (jsonNode.hasNonNull("$id")) {
            String host2 = URI.create(jsonNode.get("$id").asText()).getHost();
            String avroNamespace = Stream.of(host2.split("\\.")).map(JsonToAvroSchemaConverter::sanitizeAsAvroName).collect(Collectors.joining("."));
            return Option.of(avroNamespace);
        }
        return Option.empty();
    }

    private static String getAvroSchemaRecordName(JsonNode jsonNode) {
        if (jsonNode.hasNonNull("title")) {
            return JsonToAvroSchemaConverter.sanitizeAsAvroName(jsonNode.get("title").asText());
        }
        if (jsonNode.hasNonNull("$id")) {
            String host2 = URI.create(jsonNode.get("$id").asText()).getHost();
            String domain = StringUtils.removeSuffixBy(host2, 46);
            return JsonToAvroSchemaConverter.sanitizeAsAvroName(StringUtils.getSuffixBy(domain, 46));
        }
        return "no_name";
    }

    private static String sanitizeAsAvroName(String s) {
        return s.replaceAll("[^A-Za-z0-9_]+", "_");
    }

    private static Set<String> getRequired(JsonNode jsonNode) {
        if (!jsonNode.hasNonNull("required")) {
            return Collections.emptySet();
        }
        JsonNode requiredNode = jsonNode.get("required");
        HashSet<String> required = new HashSet<String>(requiredNode.size());
        jsonNode.get("required").elements().forEachRemaining(e -> required.add(e.asText()));
        return required;
    }

    private static String getAvroTypeName(JsonNode jsonNode, String defaultName) {
        return jsonNode.hasNonNull("title") ? jsonNode.get("title").asText() : defaultName;
    }

    private static String getAvroDoc(JsonNode jsonNode) {
        return jsonNode.hasNonNull("description") ? jsonNode.get("description").asText() : "";
    }
}

