/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources;

import io.hops.hudi.com.fasterxml.jackson.databind.ObjectMapper;
import io.hops.hudi.com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedList;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.utilities.UtilHelpers;
import org.apache.hudi.utilities.config.JsonKafkaPostProcessorConfig;
import org.apache.hudi.utilities.exception.HoodieSourcePostProcessException;
import org.apache.hudi.utilities.ingestion.HoodieIngestionMetrics;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.sources.KafkaSource;
import org.apache.hudi.utilities.sources.Source;
import org.apache.hudi.utilities.sources.helpers.KafkaOffsetGen;
import org.apache.hudi.utilities.sources.processor.JsonKafkaSourcePostProcessor;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.streaming.kafka010.KafkaUtils;
import org.apache.spark.streaming.kafka010.LocationStrategies;
import org.apache.spark.streaming.kafka010.LocationStrategy;
import org.apache.spark.streaming.kafka010.OffsetRange;

public class JsonKafkaSource
extends KafkaSource<String> {
    public JsonKafkaSource(TypedProperties properties, JavaSparkContext sparkContext, SparkSession sparkSession, SchemaProvider schemaProvider, HoodieIngestionMetrics metrics) {
        super(properties, sparkContext, sparkSession, UtilHelpers.getSchemaProviderForKafkaSource(schemaProvider, properties, sparkContext), Source.SourceType.JSON, metrics);
        properties.put("key.deserializer", StringDeserializer.class.getName());
        properties.put("value.deserializer", StringDeserializer.class.getName());
        this.offsetGen = new KafkaOffsetGen(this.props);
    }

    @Override
    JavaRDD<String> toRDD(OffsetRange[] offsetRanges) {
        JavaRDD kafkaRDD = KafkaUtils.createRDD((JavaSparkContext)this.sparkContext, this.offsetGen.getKafkaParams(), (OffsetRange[])offsetRanges, (LocationStrategy)LocationStrategies.PreferConsistent()).filter((Function & Serializable)x -> !StringUtils.isNullOrEmpty((String)x.value()));
        return this.postProcess(this.maybeAppendKafkaOffsets((JavaRDD<ConsumerRecord<Object, Object>>)kafkaRDD));
    }

    protected JavaRDD<String> maybeAppendKafkaOffsets(JavaRDD<ConsumerRecord<Object, Object>> kafkaRDD) {
        if (this.shouldAddOffsets) {
            return kafkaRDD.mapPartitions((FlatMapFunction & Serializable)partitionIterator -> {
                LinkedList stringList = new LinkedList();
                ObjectMapper om = new ObjectMapper();
                partitionIterator.forEachRemaining(consumerRecord -> {
                    String recordValue = consumerRecord.value().toString();
                    String recordKey = StringUtils.objToString(consumerRecord.key());
                    try {
                        ObjectNode jsonNode = (ObjectNode)om.readTree(recordValue);
                        jsonNode.put("_hoodie_kafka_source_offset", consumerRecord.offset());
                        jsonNode.put("_hoodie_kafka_source_partition", consumerRecord.partition());
                        jsonNode.put("_hoodie_kafka_source_timestamp", consumerRecord.timestamp());
                        jsonNode.put("_hoodie_kafka_source_key", recordKey);
                        stringList.add(om.writeValueAsString(jsonNode));
                    }
                    catch (Throwable e) {
                        stringList.add(recordValue);
                    }
                });
                return stringList.iterator();
            });
        }
        return kafkaRDD.map((Function & Serializable)consumerRecord -> (String)consumerRecord.value());
    }

    private JavaRDD<String> postProcess(JavaRDD<String> jsonStringRDD) {
        JsonKafkaSourcePostProcessor processor;
        String postProcessorClassName = ConfigUtils.getStringWithAltKeys(this.props, JsonKafkaPostProcessorConfig.JSON_KAFKA_PROCESSOR_CLASS, true);
        if (StringUtils.isNullOrEmpty(postProcessorClassName)) {
            return jsonStringRDD;
        }
        try {
            processor = UtilHelpers.createJsonKafkaSourcePostProcessor(postProcessorClassName, this.props);
        }
        catch (IOException e) {
            throw new HoodieSourcePostProcessException("Could not init " + postProcessorClassName, e);
        }
        return processor.process(jsonStringRDD);
    }
}

