/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources;

import java.util.Collections;
import java.util.List;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.utilities.config.CloudSourceConfig;
import org.apache.hudi.utilities.config.HoodieIncrSourceConfig;
import org.apache.hudi.utilities.config.S3EventsHoodieIncrSourceConfig;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.sources.HoodieIncrSource;
import org.apache.hudi.utilities.sources.helpers.CloudDataFetcher;
import org.apache.hudi.utilities.sources.helpers.CloudObjectIncrCheckpoint;
import org.apache.hudi.utilities.sources.helpers.CloudObjectMetadata;
import org.apache.hudi.utilities.sources.helpers.CloudObjectsSelectorCommon;
import org.apache.hudi.utilities.sources.helpers.IncrSourceHelper;
import org.apache.hudi.utilities.sources.helpers.QueryInfo;
import org.apache.hudi.utilities.sources.helpers.QueryRunner;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3EventsHoodieIncrSource
extends HoodieIncrSource {
    private static final Logger LOG = LoggerFactory.getLogger(S3EventsHoodieIncrSource.class);
    private final String srcPath;
    private final int numInstantsPerFetch;
    private final boolean checkIfFileExists;
    private final String fileFormat;
    private final IncrSourceHelper.MissingCheckpointStrategy missingCheckpointStrategy;
    private final QueryRunner queryRunner;
    private final CloudDataFetcher cloudDataFetcher;
    private final Option<SchemaProvider> schemaProvider;
    public static final String S3_OBJECT_KEY = "s3.object.key";
    public static final String S3_OBJECT_SIZE = "s3.object.size";
    public static final String S3_BUCKET_NAME = "s3.bucket.name";

    public S3EventsHoodieIncrSource(TypedProperties props, JavaSparkContext sparkContext, SparkSession sparkSession, SchemaProvider schemaProvider) {
        this(props, sparkContext, sparkSession, schemaProvider, new QueryRunner(sparkSession, props), new CloudDataFetcher(props, ConfigUtils.getStringWithAltKeys(props, CloudSourceConfig.DATAFILE_FORMAT, true)));
    }

    public S3EventsHoodieIncrSource(TypedProperties props, JavaSparkContext sparkContext, SparkSession sparkSession, SchemaProvider schemaProvider, QueryRunner queryRunner, CloudDataFetcher cloudDataFetcher) {
        super(props, sparkContext, sparkSession, schemaProvider);
        ConfigUtils.checkRequiredConfigProperties(props, Collections.singletonList(HoodieIncrSourceConfig.HOODIE_SRC_BASE_PATH));
        this.srcPath = ConfigUtils.getStringWithAltKeys(props, HoodieIncrSourceConfig.HOODIE_SRC_BASE_PATH);
        this.numInstantsPerFetch = ConfigUtils.getIntWithAltKeys(props, HoodieIncrSourceConfig.NUM_INSTANTS_PER_FETCH);
        this.checkIfFileExists = ConfigUtils.getBooleanWithAltKeys(props, CloudSourceConfig.ENABLE_EXISTS_CHECK);
        this.fileFormat = ConfigUtils.getStringWithAltKeys(props, HoodieIncrSourceConfig.SOURCE_FILE_FORMAT, true);
        this.missingCheckpointStrategy = IncrSourceHelper.getMissingCheckpointStrategy(props);
        this.queryRunner = queryRunner;
        this.cloudDataFetcher = cloudDataFetcher;
        this.schemaProvider = Option.ofNullable(schemaProvider);
    }

    @Override
    public Pair<Option<Dataset<Row>>, String> fetchNextBatch(Option<String> lastCheckpoint, long sourceLimit) {
        CloudObjectIncrCheckpoint cloudObjectIncrCheckpoint = CloudObjectIncrCheckpoint.fromString(lastCheckpoint);
        TimelineUtils.HollowCommitHandling handlingMode = IncrSourceHelper.getHollowCommitHandleMode(this.props);
        QueryInfo queryInfo = IncrSourceHelper.generateQueryInfo(this.sparkContext, this.srcPath, this.numInstantsPerFetch, Option.of(cloudObjectIncrCheckpoint.getCommit()), this.missingCheckpointStrategy, handlingMode, HoodieRecord.COMMIT_TIME_METADATA_FIELD, S3_OBJECT_KEY, S3_OBJECT_SIZE, true, Option.ofNullable(cloudObjectIncrCheckpoint.getKey()));
        LOG.info("Querying S3 with:" + cloudObjectIncrCheckpoint + ", queryInfo:" + queryInfo);
        if (StringUtils.isNullOrEmpty(cloudObjectIncrCheckpoint.getKey()) && queryInfo.areStartAndEndInstantsEqual()) {
            LOG.warn("Already caught up. No new data to process");
            return Pair.of(Option.empty(), queryInfo.getEndInstant());
        }
        Dataset<Row> source = this.queryRunner.run(queryInfo);
        Dataset<Row> filteredSourceData = this.applyFilter(source, this.fileFormat);
        LOG.info("Adjusting end checkpoint:" + queryInfo.getEndInstant() + " based on sourceLimit :" + sourceLimit);
        Pair<CloudObjectIncrCheckpoint, Option<Dataset<Row>>> checkPointAndDataset = IncrSourceHelper.filterAndGenerateCheckpointBasedOnSourceLimit(filteredSourceData, sourceLimit, queryInfo, cloudObjectIncrCheckpoint);
        if (!checkPointAndDataset.getRight().isPresent()) {
            LOG.info("Empty source, returning endpoint:" + queryInfo.getEndInstant());
            return Pair.of(Option.empty(), queryInfo.getEndInstant());
        }
        LOG.info("Adjusted end checkpoint :" + checkPointAndDataset.getLeft());
        String s3FS = ConfigUtils.getStringWithAltKeys(this.props, S3EventsHoodieIncrSourceConfig.S3_FS_PREFIX, true).toLowerCase();
        String s3Prefix = s3FS + "://";
        SerializableConfiguration serializableHadoopConf = new SerializableConfiguration(this.sparkContext.hadoopConfiguration());
        List cloudObjectMetadata = checkPointAndDataset.getRight().get().select(S3_BUCKET_NAME, new String[]{S3_OBJECT_KEY, S3_OBJECT_SIZE}).distinct().mapPartitions(CloudObjectsSelectorCommon.getCloudObjectMetadataPerPartition(s3Prefix, serializableHadoopConf, this.checkIfFileExists), Encoders.kryo(CloudObjectMetadata.class)).collectAsList();
        LOG.info("Total number of files to process :" + cloudObjectMetadata.size());
        Option<Dataset<Row>> datasetOption = this.cloudDataFetcher.getCloudObjectDataDF(this.sparkSession, cloudObjectMetadata, this.props, this.schemaProvider);
        return Pair.of(datasetOption, checkPointAndDataset.getLeft().toString());
    }

    Dataset<Row> applyFilter(Dataset<Row> source, String fileFormat) {
        String filter = "s3.object.size > 0";
        if (!StringUtils.isNullOrEmpty(ConfigUtils.getStringWithAltKeys(this.props, S3EventsHoodieIncrSourceConfig.S3_KEY_PREFIX, true))) {
            filter = filter + " and " + S3_OBJECT_KEY + " like '" + ConfigUtils.getStringWithAltKeys(this.props, S3EventsHoodieIncrSourceConfig.S3_KEY_PREFIX) + "%'";
        }
        if (!StringUtils.isNullOrEmpty(ConfigUtils.getStringWithAltKeys(this.props, S3EventsHoodieIncrSourceConfig.S3_IGNORE_KEY_PREFIX, true))) {
            filter = filter + " and " + S3_OBJECT_KEY + " not like '" + ConfigUtils.getStringWithAltKeys(this.props, S3EventsHoodieIncrSourceConfig.S3_IGNORE_KEY_PREFIX) + "%'";
        }
        if (!StringUtils.isNullOrEmpty(ConfigUtils.getStringWithAltKeys(this.props, S3EventsHoodieIncrSourceConfig.S3_IGNORE_KEY_SUBSTRING, true))) {
            filter = filter + " and " + S3_OBJECT_KEY + " not like '%" + ConfigUtils.getStringWithAltKeys(this.props, S3EventsHoodieIncrSourceConfig.S3_IGNORE_KEY_SUBSTRING) + "%'";
        }
        filter = filter + " and " + S3_OBJECT_KEY + " like '%" + fileFormat + "%'";
        return source.filter(filter);
    }

    public static class Config {
        @Deprecated
        static final String ENABLE_EXISTS_CHECK = S3EventsHoodieIncrSourceConfig.S3_INCR_ENABLE_EXISTS_CHECK.key();
        @Deprecated
        static final Boolean DEFAULT_ENABLE_EXISTS_CHECK = S3EventsHoodieIncrSourceConfig.S3_INCR_ENABLE_EXISTS_CHECK.defaultValue();
        @Deprecated
        static final String S3_KEY_PREFIX = S3EventsHoodieIncrSourceConfig.S3_KEY_PREFIX.key();
        @Deprecated
        static final String S3_FS_PREFIX = S3EventsHoodieIncrSourceConfig.S3_FS_PREFIX.key();
        @Deprecated
        static final String S3_IGNORE_KEY_PREFIX = S3EventsHoodieIncrSourceConfig.S3_IGNORE_KEY_PREFIX.key();
        @Deprecated
        static final String S3_IGNORE_KEY_SUBSTRING = S3EventsHoodieIncrSourceConfig.S3_IGNORE_KEY_SUBSTRING.key();
        @Deprecated
        public static final String SPARK_DATASOURCE_OPTIONS = S3EventsHoodieIncrSourceConfig.SPARK_DATASOURCE_OPTIONS.key();
    }
}

