/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources.helpers;

import com.twitter.bijection.Injection;
import com.twitter.bijection.avro.GenericAvroCodecs;
import io.hops.hudi.com.google.protobuf.Message;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.hudi.avro.MercifulJsonConverter;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.internal.schema.HoodieSchemaException;
import org.apache.hudi.utilities.config.HoodieStreamerConfig;
import org.apache.hudi.utilities.sources.helpers.ProtoConversionUtil;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public class AvroConvertor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Schema schema;
    private final String schemaStr;
    private final String invalidCharMask;
    private final boolean shouldSanitize;
    private transient MercifulJsonConverter jsonConverter;
    private transient Injection<GenericRecord, byte[]> recordInjection;

    public AvroConvertor(String schemaStr) {
        this(schemaStr, (boolean)HoodieStreamerConfig.SANITIZE_SCHEMA_FIELD_NAMES.defaultValue(), HoodieStreamerConfig.SCHEMA_FIELD_NAME_INVALID_CHAR_MASK.defaultValue());
    }

    public AvroConvertor(String schemaStr, boolean shouldSanitize, String invalidCharMask) {
        this.schemaStr = schemaStr;
        this.shouldSanitize = shouldSanitize;
        this.invalidCharMask = invalidCharMask;
    }

    public AvroConvertor(Schema schema) {
        this(schema, (boolean)HoodieStreamerConfig.SANITIZE_SCHEMA_FIELD_NAMES.defaultValue(), HoodieStreamerConfig.SCHEMA_FIELD_NAME_INVALID_CHAR_MASK.defaultValue());
    }

    public AvroConvertor(Schema schema, boolean shouldSanitize, String invalidCharMask) {
        this.schemaStr = schema.toString();
        this.schema = schema;
        this.shouldSanitize = shouldSanitize;
        this.invalidCharMask = invalidCharMask;
    }

    private void initSchema() {
        if (this.schema == null) {
            Schema.Parser parser = new Schema.Parser();
            this.schema = parser.parse(this.schemaStr);
        }
    }

    private void initInjection() {
        if (this.recordInjection == null) {
            this.recordInjection = GenericAvroCodecs.toBinary((Schema)this.schema);
        }
    }

    private void initJsonConvertor() {
        if (this.jsonConverter == null) {
            this.jsonConverter = new MercifulJsonConverter(this.shouldSanitize, this.invalidCharMask);
        }
    }

    public GenericRecord fromJson(String json) {
        try {
            this.initSchema();
            this.initJsonConvertor();
            return this.jsonConverter.convert(json, this.schema);
        }
        catch (Exception e) {
            if (json != null) {
                throw new HoodieSchemaException("Failed to convert schema from json to avro: " + json, e);
            }
            throw new HoodieSchemaException("Failed to convert schema from json to avro. Schema string was null.", e);
        }
    }

    public Either<GenericRecord, String> fromJsonWithError(String json) {
        GenericRecord genericRecord;
        try {
            genericRecord = this.fromJson(json);
        }
        catch (Exception e) {
            return new Right<GenericRecord, String>(json);
        }
        return new Left<GenericRecord, String>(genericRecord);
    }

    public Schema getSchema() {
        try {
            return new Schema.Parser().parse(this.schemaStr);
        }
        catch (Exception e) {
            throw new HoodieSchemaException("Failed to parse json schema: " + this.schemaStr, e);
        }
    }

    public GenericRecord fromAvroBinary(byte[] avroBinary) {
        try {
            this.initSchema();
            this.initInjection();
            return (GenericRecord)this.recordInjection.invert((Object)avroBinary).get();
        }
        catch (Exception e) {
            if (avroBinary != null) {
                throw new HoodieSchemaException("Failed to get avro schema from avro binary: " + Arrays.toString(avroBinary), e);
            }
            throw new HoodieSchemaException("Failed to get avro schema from avro binary. Binary is null", e);
        }
    }

    public GenericRecord fromProtoMessage(Message message) {
        try {
            this.initSchema();
            return ProtoConversionUtil.convertToAvro(this.schema, message);
        }
        catch (Exception e) {
            throw new HoodieSchemaException("Failed to get avro schema from proto message", e);
        }
    }

    public GenericRecord withKafkaFieldsAppended(ConsumerRecord consumerRecord) {
        this.initSchema();
        GenericRecord recordValue = (GenericRecord)consumerRecord.value();
        GenericRecordBuilder recordBuilder = new GenericRecordBuilder(this.schema);
        for (Schema.Field field2 : recordValue.getSchema().getFields()) {
            recordBuilder.set(field2, recordValue.get(field2.name()));
        }
        String recordKey = StringUtils.objToString(consumerRecord.key());
        recordBuilder.set("_hoodie_kafka_source_offset", (Object)consumerRecord.offset());
        recordBuilder.set("_hoodie_kafka_source_partition", (Object)consumerRecord.partition());
        recordBuilder.set("_hoodie_kafka_source_timestamp", (Object)consumerRecord.timestamp());
        recordBuilder.set("_hoodie_kafka_source_key", (Object)recordKey);
        return recordBuilder.build();
    }
}

