/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.transform;

import java.util.List;
import org.apache.avro.Schema;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.utilities.streamer.ErrorTableUtils;
import org.apache.hudi.utilities.transform.ChainedTransformer;
import org.apache.hudi.utilities.transform.Transformer;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;

public class ErrorTableAwareChainedTransformer
extends ChainedTransformer {
    public ErrorTableAwareChainedTransformer(List<String> configuredTransformers, Option<Schema> sourceSchemaOpt) {
        super(configuredTransformers, sourceSchemaOpt);
    }

    public ErrorTableAwareChainedTransformer(List<Transformer> transformers) {
        super(transformers);
    }

    @Override
    public Dataset<Row> apply(JavaSparkContext jsc, SparkSession sparkSession, Dataset<Row> rowDataset, TypedProperties properties) {
        Dataset<Row> dataset = rowDataset;
        dataset = ErrorTableUtils.addNullValueErrorTableCorruptRecordColumn(dataset);
        for (ChainedTransformer.TransformerInfo transformerInfo : this.transformers) {
            Transformer transformer = transformerInfo.getTransformer();
            dataset = transformer.apply(jsc, sparkSession, dataset, transformerInfo.getProperties(properties, this.transformers));
            ErrorTableUtils.validate(dataset);
        }
        return dataset;
    }

    @Override
    public StructType transformedSchema(JavaSparkContext jsc, SparkSession sparkSession, StructType incomingStruct, TypedProperties properties) {
        return super.transformedSchema(jsc, sparkSession, incomingStruct, properties);
    }
}

