/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.graphite;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricAttribute;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteSender;
import java.io.IOException;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphiteReporter
extends ScheduledReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphiteReporter.class);
    private final GraphiteSender graphite;
    private final Clock clock;
    private final String prefix;

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    protected GraphiteReporter(MetricRegistry registry, GraphiteSender graphite, Clock clock, String prefix, TimeUnit rateUnit, TimeUnit durationUnit, MetricFilter filter, ScheduledExecutorService executor, boolean shutdownExecutorOnStop, Set<MetricAttribute> disabledMetricAttributes) {
        super(registry, "graphite-reporter", filter, rateUnit, durationUnit, executor, shutdownExecutorOnStop, disabledMetricAttributes);
        this.graphite = graphite;
        this.clock = clock;
        this.prefix = prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        long timestamp = this.clock.getTime() / 1000L;
        try {
            this.graphite.connect();
            for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
                this.reportGauge(entry.getKey(), entry.getValue(), timestamp);
            }
            for (Map.Entry<String, Metric> entry : counters.entrySet()) {
                this.reportCounter(entry.getKey(), (Counter)entry.getValue(), timestamp);
            }
            for (Map.Entry<String, Metric> entry : histograms.entrySet()) {
                this.reportHistogram(entry.getKey(), (Histogram)entry.getValue(), timestamp);
            }
            for (Map.Entry<String, Metric> entry : meters.entrySet()) {
                this.reportMetered(entry.getKey(), (Metered)entry.getValue(), timestamp);
            }
            for (Map.Entry<String, Metric> entry : timers.entrySet()) {
                this.reportTimer(entry.getKey(), (Timer)entry.getValue(), timestamp);
            }
            this.graphite.flush();
        }
        catch (IOException e) {
            LOGGER.warn("Unable to report to Graphite", (Object)this.graphite, (Object)e);
        }
        finally {
            try {
                this.graphite.close();
            }
            catch (IOException e1) {
                LOGGER.warn("Error closing Graphite", (Object)this.graphite, (Object)e1);
            }
        }
    }

    @Override
    public void stop() {
        try {
            super.stop();
        }
        finally {
            try {
                this.graphite.close();
            }
            catch (IOException e) {
                LOGGER.debug("Error disconnecting from Graphite", (Object)this.graphite, (Object)e);
            }
        }
    }

    private void reportTimer(String name2, Timer timer, long timestamp) throws IOException {
        Snapshot snapshot = timer.getSnapshot();
        this.sendIfEnabled(MetricAttribute.MAX, name2, this.convertDuration(snapshot.getMax()), timestamp);
        this.sendIfEnabled(MetricAttribute.MEAN, name2, this.convertDuration(snapshot.getMean()), timestamp);
        this.sendIfEnabled(MetricAttribute.MIN, name2, this.convertDuration(snapshot.getMin()), timestamp);
        this.sendIfEnabled(MetricAttribute.STDDEV, name2, this.convertDuration(snapshot.getStdDev()), timestamp);
        this.sendIfEnabled(MetricAttribute.P50, name2, this.convertDuration(snapshot.getMedian()), timestamp);
        this.sendIfEnabled(MetricAttribute.P75, name2, this.convertDuration(snapshot.get75thPercentile()), timestamp);
        this.sendIfEnabled(MetricAttribute.P95, name2, this.convertDuration(snapshot.get95thPercentile()), timestamp);
        this.sendIfEnabled(MetricAttribute.P98, name2, this.convertDuration(snapshot.get98thPercentile()), timestamp);
        this.sendIfEnabled(MetricAttribute.P99, name2, this.convertDuration(snapshot.get99thPercentile()), timestamp);
        this.sendIfEnabled(MetricAttribute.P999, name2, this.convertDuration(snapshot.get999thPercentile()), timestamp);
        this.reportMetered(name2, timer, timestamp);
    }

    private void reportMetered(String name2, Metered meter, long timestamp) throws IOException {
        this.sendIfEnabled(MetricAttribute.COUNT, name2, meter.getCount(), timestamp);
        this.sendIfEnabled(MetricAttribute.M1_RATE, name2, this.convertRate(meter.getOneMinuteRate()), timestamp);
        this.sendIfEnabled(MetricAttribute.M5_RATE, name2, this.convertRate(meter.getFiveMinuteRate()), timestamp);
        this.sendIfEnabled(MetricAttribute.M15_RATE, name2, this.convertRate(meter.getFifteenMinuteRate()), timestamp);
        this.sendIfEnabled(MetricAttribute.MEAN_RATE, name2, this.convertRate(meter.getMeanRate()), timestamp);
    }

    private void reportHistogram(String name2, Histogram histogram, long timestamp) throws IOException {
        Snapshot snapshot = histogram.getSnapshot();
        this.sendIfEnabled(MetricAttribute.COUNT, name2, histogram.getCount(), timestamp);
        this.sendIfEnabled(MetricAttribute.MAX, name2, snapshot.getMax(), timestamp);
        this.sendIfEnabled(MetricAttribute.MEAN, name2, snapshot.getMean(), timestamp);
        this.sendIfEnabled(MetricAttribute.MIN, name2, snapshot.getMin(), timestamp);
        this.sendIfEnabled(MetricAttribute.STDDEV, name2, snapshot.getStdDev(), timestamp);
        this.sendIfEnabled(MetricAttribute.P50, name2, snapshot.getMedian(), timestamp);
        this.sendIfEnabled(MetricAttribute.P75, name2, snapshot.get75thPercentile(), timestamp);
        this.sendIfEnabled(MetricAttribute.P95, name2, snapshot.get95thPercentile(), timestamp);
        this.sendIfEnabled(MetricAttribute.P98, name2, snapshot.get98thPercentile(), timestamp);
        this.sendIfEnabled(MetricAttribute.P99, name2, snapshot.get99thPercentile(), timestamp);
        this.sendIfEnabled(MetricAttribute.P999, name2, snapshot.get999thPercentile(), timestamp);
    }

    private void sendIfEnabled(MetricAttribute type2, String name2, double value, long timestamp) throws IOException {
        if (this.getDisabledMetricAttributes().contains((Object)type2)) {
            return;
        }
        this.graphite.send(this.prefix(name2, type2.getCode()), this.format(value), timestamp);
    }

    private void sendIfEnabled(MetricAttribute type2, String name2, long value, long timestamp) throws IOException {
        if (this.getDisabledMetricAttributes().contains((Object)type2)) {
            return;
        }
        this.graphite.send(this.prefix(name2, type2.getCode()), this.format(value), timestamp);
    }

    private void reportCounter(String name2, Counter counter2, long timestamp) throws IOException {
        this.graphite.send(this.prefix(name2, MetricAttribute.COUNT.getCode()), this.format(counter2.getCount()), timestamp);
    }

    private void reportGauge(String name2, Gauge<?> gauge, long timestamp) throws IOException {
        String value = this.format(gauge.getValue());
        if (value != null) {
            this.graphite.send(this.prefix(name2), value, timestamp);
        }
    }

    private String format(Object o) {
        if (o instanceof Float) {
            return this.format(((Float)o).doubleValue());
        }
        if (o instanceof Double) {
            return this.format((Double)o);
        }
        if (o instanceof Byte) {
            return this.format(((Byte)o).longValue());
        }
        if (o instanceof Short) {
            return this.format(((Short)o).longValue());
        }
        if (o instanceof Integer) {
            return this.format(((Integer)o).longValue());
        }
        if (o instanceof Long) {
            return this.format((Long)o);
        }
        if (o instanceof Number) {
            return this.format(((Number)o).doubleValue());
        }
        if (o instanceof Boolean) {
            return this.format((Boolean)o != false ? 1L : 0L);
        }
        return null;
    }

    private String prefix(String ... components) {
        return MetricRegistry.name(this.prefix, components);
    }

    private String format(long n) {
        return Long.toString(n);
    }

    protected String format(double v) {
        return String.format(Locale.US, "%2.2f", v);
    }

    public static class Builder {
        private final MetricRegistry registry;
        private Clock clock;
        private String prefix;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private MetricFilter filter;
        private ScheduledExecutorService executor;
        private boolean shutdownExecutorOnStop;
        private Set<MetricAttribute> disabledMetricAttributes;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.clock = Clock.defaultClock();
            this.prefix = null;
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.filter = MetricFilter.ALL;
            this.executor = null;
            this.shutdownExecutorOnStop = true;
            this.disabledMetricAttributes = Collections.emptySet();
        }

        public Builder shutdownExecutorOnStop(boolean shutdownExecutorOnStop) {
            this.shutdownExecutorOnStop = shutdownExecutorOnStop;
            return this;
        }

        public Builder scheduleOn(ScheduledExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder prefixedWith(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public Builder disabledMetricAttributes(Set<MetricAttribute> disabledMetricAttributes) {
            this.disabledMetricAttributes = disabledMetricAttributes;
            return this;
        }

        public GraphiteReporter build(Graphite graphite) {
            return this.build((GraphiteSender)graphite);
        }

        public GraphiteReporter build(GraphiteSender graphite) {
            return new GraphiteReporter(this.registry, graphite, this.clock, this.prefix, this.rateUnit, this.durationUnit, this.filter, this.executor, this.shutdownExecutorOnStop, this.disabledMetricAttributes);
        }
    }
}

