/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.com.esotericsoftware.kryo.serializers;

import io.hops.hudi.com.esotericsoftware.kryo.Kryo;
import io.hops.hudi.com.esotericsoftware.kryo.KryoException;
import io.hops.hudi.com.esotericsoftware.kryo.Serializer;
import io.hops.hudi.com.esotericsoftware.kryo.io.Input;
import io.hops.hudi.com.esotericsoftware.kryo.io.InputChunked;
import io.hops.hudi.com.esotericsoftware.kryo.io.Output;
import io.hops.hudi.com.esotericsoftware.kryo.io.OutputChunked;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class DeflateSerializer
extends Serializer {
    private final Serializer serializer;
    private boolean noHeaders = true;
    private int compressionLevel = 4;

    public DeflateSerializer(Serializer serializer) {
        this.serializer = serializer;
    }

    public void write(Kryo kryo, Output output, Object object) {
        OutputChunked outputChunked = new OutputChunked(output, 256);
        Deflater deflater = new Deflater(this.compressionLevel, this.noHeaders);
        try {
            DeflaterOutputStream deflaterStream = new DeflaterOutputStream((OutputStream)outputChunked, deflater);
            Output deflaterOutput = new Output(deflaterStream, 256);
            this.serializer.write(kryo, deflaterOutput, object);
            deflaterOutput.flush();
            deflaterStream.finish();
        }
        catch (IOException ex) {
            throw new KryoException(ex);
        }
        finally {
            deflater.end();
        }
        outputChunked.endChunks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object read(Kryo kryo, Input input, Class type2) {
        Inflater inflater = new Inflater(this.noHeaders);
        try {
            InflaterInputStream inflaterStream = new InflaterInputStream(new InputChunked(input, 256), inflater);
            Object t = this.serializer.read(kryo, new Input(inflaterStream, 256), type2);
            return t;
        }
        finally {
            inflater.end();
        }
    }

    public void setNoHeaders(boolean noHeaders) {
        this.noHeaders = noHeaders;
    }

    public void setCompressionLevel(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    public Object copy(Kryo kryo, Object original) {
        return this.serializer.copy(kryo, original);
    }
}

