/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.com.esotericsoftware.kryo.serializers;

import io.hops.hudi.com.esotericsoftware.kryo.Kryo;
import io.hops.hudi.com.esotericsoftware.kryo.KryoException;
import io.hops.hudi.com.esotericsoftware.kryo.Serializer;
import io.hops.hudi.com.esotericsoftware.kryo.io.Input;
import io.hops.hudi.com.esotericsoftware.kryo.io.Output;

public class EnumNameSerializer
extends Serializer<Enum> {
    private final Class<? extends Enum> enumType;
    private final Serializer stringSerializer;

    public EnumNameSerializer(Kryo kryo, Class<? extends Enum> type2) {
        this.enumType = type2;
        this.stringSerializer = kryo.getSerializer(String.class);
        this.setImmutable(true);
    }

    @Override
    public void write(Kryo kryo, Output output, Enum object) {
        kryo.writeObject(output, object.name(), this.stringSerializer);
    }

    @Override
    public Enum read(Kryo kryo, Input input, Class<Enum> type2) {
        String name2 = kryo.readObject(input, String.class, this.stringSerializer);
        try {
            return Enum.valueOf(this.enumType, name2);
        }
        catch (IllegalArgumentException e) {
            throw new KryoException("Invalid name for enum \"" + this.enumType.getName() + "\": " + name2, e);
        }
    }
}

