/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.com.esotericsoftware.kryo.serializers;

import io.hops.hudi.com.esotericsoftware.kryo.Kryo;
import io.hops.hudi.com.esotericsoftware.kryo.NotNull;
import io.hops.hudi.com.esotericsoftware.kryo.Serializer;
import io.hops.hudi.com.esotericsoftware.kryo.io.Input;
import io.hops.hudi.com.esotericsoftware.kryo.io.Output;
import io.hops.hudi.com.esotericsoftware.kryo.serializers.AsmCachedFieldFactory;
import io.hops.hudi.com.esotericsoftware.kryo.serializers.FieldSerializerAnnotationsUtil;
import io.hops.hudi.com.esotericsoftware.kryo.serializers.FieldSerializerConfig;
import io.hops.hudi.com.esotericsoftware.kryo.serializers.FieldSerializerGenericsUtil;
import io.hops.hudi.com.esotericsoftware.kryo.serializers.FieldSerializerUnsafeUtil;
import io.hops.hudi.com.esotericsoftware.kryo.serializers.Generics;
import io.hops.hudi.com.esotericsoftware.kryo.serializers.ObjectCachedFieldFactory;
import io.hops.hudi.com.esotericsoftware.kryo.serializers.ObjectField;
import io.hops.hudi.com.esotericsoftware.kryo.util.IntArray;
import io.hops.hudi.com.esotericsoftware.kryo.util.ObjectMap;
import io.hops.hudi.com.esotericsoftware.kryo.util.Util;
import io.hops.hudi.com.esotericsoftware.minlog.Log;
import io.hops.hudi.com.esotericsoftware.reflectasm.FieldAccess;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

public class FieldSerializer<T>
extends Serializer<T>
implements Comparator<CachedField> {
    final Kryo kryo;
    final Class type;
    final TypeVariable[] typeParameters;
    final Class componentType;
    protected final FieldSerializerConfig config;
    private CachedField[] fields = new CachedField[0];
    private CachedField[] transientFields = new CachedField[0];
    protected HashSet<CachedField> removedFields = new HashSet();
    Object access;
    private FieldSerializerUnsafeUtil unsafeUtil;
    private FieldSerializerGenericsUtil genericsUtil;
    private FieldSerializerAnnotationsUtil annotationsUtil;
    private Class[] generics;
    private Generics genericsScope;
    private boolean varIntsEnabled = true;
    private boolean useMemRegions = false;
    private boolean hasObjectFields = false;
    static CachedFieldFactory asmFieldFactory;
    static CachedFieldFactory objectFieldFactory;
    static CachedFieldFactory unsafeFieldFactory;
    static boolean unsafeAvailable;
    static Class<?> unsafeUtilClass;
    static Method sortFieldsByOffsetMethod;

    public FieldSerializer(Kryo kryo, Class type2) {
        this(kryo, type2, null);
    }

    public FieldSerializer(Kryo kryo, Class type2, Class[] generics) {
        this(kryo, type2, generics, kryo.getFieldSerializerConfig().clone());
    }

    protected FieldSerializer(Kryo kryo, Class type2, Class[] generics, FieldSerializerConfig config) {
        if (Log.TRACE) {
            Log.trace("kryo", "Optimize ints: " + this.varIntsEnabled);
        }
        this.config = config;
        this.kryo = kryo;
        this.type = type2;
        this.generics = generics;
        this.typeParameters = type2.getTypeParameters();
        this.componentType = this.typeParameters == null || this.typeParameters.length == 0 ? type2.getComponentType() : null;
        this.genericsUtil = new FieldSerializerGenericsUtil(this);
        this.unsafeUtil = FieldSerializerUnsafeUtil.Factory.getInstance(this);
        this.annotationsUtil = new FieldSerializerAnnotationsUtil(this);
        this.rebuildCachedFields();
    }

    protected void rebuildCachedFields() {
        this.rebuildCachedFields(false);
    }

    protected void rebuildCachedFields(boolean minorRebuild) {
        List<Field> validTransientFields;
        List<Field> validFields;
        if (Log.TRACE && this.generics != null) {
            Log.trace("kryo", "Generic type parameters: " + Arrays.toString(this.generics));
        }
        if (this.type.isInterface()) {
            this.fields = new CachedField[0];
            return;
        }
        this.hasObjectFields = false;
        if (this.config.isOptimizedGenerics()) {
            Generics genScope;
            this.genericsScope = genScope = this.genericsUtil.buildGenericsScope(this.type, this.generics);
            if (this.genericsScope != null) {
                this.kryo.getGenericsResolver().pushScope(this.type, this.genericsScope);
            }
        }
        IntArray useAsm = new IntArray();
        if (!minorRebuild) {
            List<Field> allFields = new ArrayList<Field>();
            for (Class nextClass = this.type; nextClass != Object.class; nextClass = nextClass.getSuperclass()) {
                Field[] declaredFields = nextClass.getDeclaredFields();
                if (declaredFields == null) continue;
                for (Field f : declaredFields) {
                    if (Modifier.isStatic(f.getModifiers())) continue;
                    allFields.add(f);
                }
            }
            ObjectMap context = this.kryo.getContext();
            if (this.useMemRegions && !this.config.isUseAsm() && unsafeAvailable) {
                try {
                    Field[] allFieldsArray = (Field[])sortFieldsByOffsetMethod.invoke(null, allFields);
                    allFields = Arrays.asList(allFieldsArray);
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot invoke UnsafeUtil.sortFieldsByOffset()", e);
                }
            }
            validFields = this.buildValidFields(false, allFields, context, useAsm);
            validTransientFields = this.buildValidFields(true, allFields, context, useAsm);
            if (this.config.isUseAsm() && !Util.IS_ANDROID && Modifier.isPublic(this.type.getModifiers()) && useAsm.indexOf(1) != -1) {
                try {
                    this.access = FieldAccess.get(this.type);
                }
                catch (RuntimeException e) {}
            }
        } else {
            validFields = this.buildValidFieldsFromCachedFields(this.fields, useAsm);
            validTransientFields = this.buildValidFieldsFromCachedFields(this.transientFields, useAsm);
        }
        ArrayList<CachedField> cachedFields = new ArrayList<CachedField>(validFields.size());
        ArrayList<CachedField> cachedTransientFields = new ArrayList<CachedField>(validTransientFields.size());
        this.createCachedFields(useAsm, validFields, cachedFields, 0);
        this.createCachedFields(useAsm, validTransientFields, cachedTransientFields, validFields.size());
        Collections.sort(cachedFields, this);
        this.fields = cachedFields.toArray(new CachedField[cachedFields.size()]);
        Collections.sort(cachedTransientFields, this);
        this.transientFields = cachedTransientFields.toArray(new CachedField[cachedTransientFields.size()]);
        this.initializeCachedFields();
        if (this.genericsScope != null) {
            this.kryo.getGenericsResolver().popScope();
        }
        if (!minorRebuild) {
            for (CachedField field2 : this.removedFields) {
                this.removeField(field2);
            }
        }
        this.annotationsUtil.processAnnotatedFields(this);
    }

    private List<Field> buildValidFieldsFromCachedFields(CachedField[] cachedFields, IntArray useAsm) {
        ArrayList<Field> fields2 = new ArrayList<Field>(cachedFields.length);
        for (CachedField f : cachedFields) {
            fields2.add(f.field);
            useAsm.add(f.accessIndex > -1 ? 1 : 0);
        }
        return fields2;
    }

    private List<Field> buildValidFields(boolean transientFields, List<Field> allFields, ObjectMap context, IntArray useAsm) {
        ArrayList<Field> result2 = new ArrayList<Field>(allFields.size());
        int n = allFields.size();
        for (int i = 0; i < n; ++i) {
            Optional optional;
            Field field2 = allFields.get(i);
            int modifiers = field2.getModifiers();
            if (Modifier.isTransient(modifiers) != transientFields || Modifier.isStatic(modifiers) || field2.isSynthetic() && this.config.isIgnoreSyntheticFields()) continue;
            if (!field2.isAccessible()) {
                if (!this.config.isSetFieldsAsAccessible()) continue;
                try {
                    field2.setAccessible(true);
                }
                catch (AccessControlException ex) {
                    continue;
                }
            }
            if ((optional = field2.getAnnotation(Optional.class)) != null && !context.containsKey(optional.value())) continue;
            result2.add(field2);
            useAsm.add(!Modifier.isFinal(modifiers) && Modifier.isPublic(modifiers) && Modifier.isPublic(field2.getType().getModifiers()) ? 1 : 0);
        }
        return result2;
    }

    private void createCachedFields(IntArray useAsm, List<Field> validFields, List<CachedField> cachedFields, int baseIndex) {
        if (this.config.isUseAsm() || !this.useMemRegions) {
            int n = validFields.size();
            for (int i = 0; i < n; ++i) {
                Field field2 = validFields.get(i);
                int accessIndex = -1;
                if (this.access != null && useAsm.get(baseIndex + i) == 1) {
                    accessIndex = ((FieldAccess)this.access).getIndex(field2.getName());
                }
                cachedFields.add(this.newCachedField(field2, cachedFields.size(), accessIndex));
            }
        } else {
            this.unsafeUtil.createUnsafeCacheFieldsAndRegions(validFields, cachedFields, baseIndex, useAsm);
        }
    }

    @Override
    public void setGenerics(Kryo kryo, Class[] generics) {
        if (!this.config.isOptimizedGenerics()) {
            return;
        }
        this.generics = generics;
        if (this.typeParameters != null && this.typeParameters.length > 0) {
            this.rebuildCachedFields(true);
        }
    }

    public Class[] getGenerics() {
        return this.generics;
    }

    protected void initializeCachedFields() {
    }

    CachedField newCachedField(Field field2, int fieldIndex, int accessIndex) {
        CachedField cachedField;
        Type fieldGenericType;
        Class[] fieldClass = new Class[]{field2.getType()};
        Type type2 = fieldGenericType = this.config.isOptimizedGenerics() ? field2.getGenericType() : null;
        if (!this.config.isOptimizedGenerics() || fieldGenericType == fieldClass[0]) {
            if (Log.TRACE) {
                Log.trace("kryo", "Field " + field2.getName() + ": " + fieldClass[0]);
            }
            cachedField = this.newMatchingCachedField(field2, accessIndex, fieldClass[0], fieldGenericType, null);
        } else {
            cachedField = this.genericsUtil.newCachedFieldOfGenericType(field2, accessIndex, fieldClass, fieldGenericType);
        }
        if (cachedField instanceof ObjectField) {
            this.hasObjectFields = true;
        }
        cachedField.field = field2;
        cachedField.varIntsEnabled = this.varIntsEnabled;
        if (!this.config.isUseAsm()) {
            cachedField.offset = this.unsafeUtil.getObjectFieldOffset(field2);
        }
        cachedField.access = (FieldAccess)this.access;
        cachedField.accessIndex = accessIndex;
        boolean bl = cachedField.canBeNull = this.config.isFieldsCanBeNull() && !fieldClass[0].isPrimitive() && !field2.isAnnotationPresent(NotNull.class);
        if (this.kryo.isFinal(fieldClass[0]) || this.config.isFixedFieldTypes()) {
            cachedField.valueClass = fieldClass[0];
        }
        return cachedField;
    }

    CachedField newMatchingCachedField(Field field2, int accessIndex, Class fieldClass, Type fieldGenericType, Class[] fieldGenerics) {
        CachedField cachedField;
        if (accessIndex != -1) {
            cachedField = this.getAsmFieldFactory().createCachedField(fieldClass, field2, this);
        } else if (!this.config.isUseAsm()) {
            cachedField = this.getUnsafeFieldFactory().createCachedField(fieldClass, field2, this);
        } else {
            cachedField = this.getObjectFieldFactory().createCachedField(fieldClass, field2, this);
            if (this.config.isOptimizedGenerics()) {
                if (fieldGenerics != null) {
                    ((ObjectField)cachedField).generics = fieldGenerics;
                } else if (fieldGenericType != null) {
                    Object[] cachedFieldGenerics = FieldSerializerGenericsUtil.getGenerics(fieldGenericType, this.kryo);
                    ((ObjectField)cachedField).generics = cachedFieldGenerics;
                    if (Log.TRACE) {
                        Log.trace("kryo", "Field generics: " + Arrays.toString(cachedFieldGenerics));
                    }
                }
            }
        }
        return cachedField;
    }

    private CachedFieldFactory getAsmFieldFactory() {
        if (asmFieldFactory == null) {
            asmFieldFactory = new AsmCachedFieldFactory();
        }
        return asmFieldFactory;
    }

    private CachedFieldFactory getObjectFieldFactory() {
        if (objectFieldFactory == null) {
            objectFieldFactory = new ObjectCachedFieldFactory();
        }
        return objectFieldFactory;
    }

    private CachedFieldFactory getUnsafeFieldFactory() {
        if (unsafeFieldFactory == null) {
            try {
                unsafeFieldFactory = (CachedFieldFactory)this.getClass().getClassLoader().loadClass("io.hops.hudi.com.esotericsoftware.kryo.serializers.UnsafeCachedFieldFactory").newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot create UnsafeFieldFactory", e);
            }
        }
        return unsafeFieldFactory;
    }

    @Override
    public int compare(CachedField o1, CachedField o2) {
        return this.getCachedFieldName(o1).compareTo(this.getCachedFieldName(o2));
    }

    public void setFieldsCanBeNull(boolean fieldsCanBeNull) {
        this.config.setFieldsCanBeNull(fieldsCanBeNull);
        this.rebuildCachedFields();
    }

    public void setFieldsAsAccessible(boolean setFieldsAsAccessible) {
        this.config.setFieldsAsAccessible(setFieldsAsAccessible);
        this.rebuildCachedFields();
    }

    public void setIgnoreSyntheticFields(boolean ignoreSyntheticFields) {
        this.config.setIgnoreSyntheticFields(ignoreSyntheticFields);
        this.rebuildCachedFields();
    }

    public void setFixedFieldTypes(boolean fixedFieldTypes) {
        this.config.setFixedFieldTypes(fixedFieldTypes);
        this.rebuildCachedFields();
    }

    public void setUseAsm(boolean setUseAsm) {
        this.config.setUseAsm(setUseAsm);
        this.rebuildCachedFields();
    }

    public void setCopyTransient(boolean setCopyTransient) {
        this.config.setCopyTransient(setCopyTransient);
    }

    public void setSerializeTransient(boolean setSerializeTransient) {
        this.config.setSerializeTransient(setSerializeTransient);
    }

    public void setOptimizedGenerics(boolean setOptimizedGenerics) {
        this.config.setOptimizedGenerics(setOptimizedGenerics);
        this.rebuildCachedFields();
    }

    @Override
    public void write(Kryo kryo, Output output, T object) {
        int i;
        if (Log.TRACE) {
            Log.trace("kryo", "FieldSerializer.write fields of class: " + object.getClass().getName());
        }
        if (this.config.isOptimizedGenerics()) {
            if (this.typeParameters != null && this.generics != null) {
                this.rebuildCachedFields();
            }
            if (this.genericsScope != null) {
                kryo.getGenericsResolver().pushScope(this.type, this.genericsScope);
            }
        }
        CachedField[] fields2 = this.fields;
        int n = fields2.length;
        for (i = 0; i < n; ++i) {
            fields2[i].write(output, object);
        }
        if (this.config.isSerializeTransient()) {
            n = this.transientFields.length;
            for (i = 0; i < n; ++i) {
                this.transientFields[i].write(output, object);
            }
        }
        if (this.config.isOptimizedGenerics() && this.genericsScope != null) {
            kryo.getGenericsResolver().popScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T read(Kryo kryo, Input input, Class<T> type2) {
        try {
            int i;
            if (this.config.isOptimizedGenerics()) {
                if (this.typeParameters != null && this.generics != null) {
                    this.rebuildCachedFields();
                }
                if (this.genericsScope != null) {
                    kryo.getGenericsResolver().pushScope(type2, this.genericsScope);
                }
            }
            T object = this.create(kryo, input, type2);
            kryo.reference(object);
            CachedField[] fields2 = this.fields;
            int n = fields2.length;
            for (i = 0; i < n; ++i) {
                fields2[i].read(input, object);
            }
            if (this.config.isSerializeTransient()) {
                n = this.transientFields.length;
                for (i = 0; i < n; ++i) {
                    this.transientFields[i].read(input, object);
                }
            }
            T t = object;
            return t;
        }
        finally {
            if (this.config.isOptimizedGenerics() && this.genericsScope != null && kryo.getGenericsResolver() != null) {
                kryo.getGenericsResolver().popScope();
            }
        }
    }

    protected T create(Kryo kryo, Input input, Class<T> type2) {
        return kryo.newInstance(type2);
    }

    public CachedField getField(String fieldName) {
        for (CachedField cachedField : this.fields) {
            if (!this.getCachedFieldName(cachedField).equals(fieldName)) continue;
            return cachedField;
        }
        throw new IllegalArgumentException("Field \"" + fieldName + "\" not found on class: " + this.type.getName());
    }

    protected String getCachedFieldName(CachedField cachedField) {
        return this.config.getCachedFieldNameStrategy().getName(cachedField);
    }

    public void removeField(String fieldName) {
        CachedField cachedField;
        int i;
        for (i = 0; i < this.fields.length; ++i) {
            cachedField = this.fields[i];
            if (!this.getCachedFieldName(cachedField).equals(fieldName)) continue;
            CachedField[] newFields = new CachedField[this.fields.length - 1];
            System.arraycopy(this.fields, 0, newFields, 0, i);
            System.arraycopy(this.fields, i + 1, newFields, i, newFields.length - i);
            this.fields = newFields;
            this.removedFields.add(cachedField);
            return;
        }
        for (i = 0; i < this.transientFields.length; ++i) {
            cachedField = this.transientFields[i];
            if (!this.getCachedFieldName(cachedField).equals(fieldName)) continue;
            CachedField[] newFields = new CachedField[this.transientFields.length - 1];
            System.arraycopy(this.transientFields, 0, newFields, 0, i);
            System.arraycopy(this.transientFields, i + 1, newFields, i, newFields.length - i);
            this.transientFields = newFields;
            this.removedFields.add(cachedField);
            return;
        }
        throw new IllegalArgumentException("Field \"" + fieldName + "\" not found on class: " + this.type.getName());
    }

    public void removeField(CachedField removeField) {
        CachedField cachedField;
        int i;
        for (i = 0; i < this.fields.length; ++i) {
            cachedField = this.fields[i];
            if (cachedField != removeField) continue;
            CachedField[] newFields = new CachedField[this.fields.length - 1];
            System.arraycopy(this.fields, 0, newFields, 0, i);
            System.arraycopy(this.fields, i + 1, newFields, i, newFields.length - i);
            this.fields = newFields;
            this.removedFields.add(cachedField);
            return;
        }
        for (i = 0; i < this.transientFields.length; ++i) {
            cachedField = this.transientFields[i];
            if (cachedField != removeField) continue;
            CachedField[] newFields = new CachedField[this.transientFields.length - 1];
            System.arraycopy(this.transientFields, 0, newFields, 0, i);
            System.arraycopy(this.transientFields, i + 1, newFields, i, newFields.length - i);
            this.transientFields = newFields;
            this.removedFields.add(cachedField);
            return;
        }
        throw new IllegalArgumentException("Field \"" + removeField + "\" not found on class: " + this.type.getName());
    }

    public CachedField[] getFields() {
        return this.fields;
    }

    public CachedField[] getTransientFields() {
        return this.transientFields;
    }

    public Class getType() {
        return this.type;
    }

    public Kryo getKryo() {
        return this.kryo;
    }

    public boolean getUseAsmEnabled() {
        return this.config.isUseAsm();
    }

    public boolean getUseMemRegions() {
        return this.useMemRegions;
    }

    public boolean getCopyTransient() {
        return this.config.isCopyTransient();
    }

    public boolean getSerializeTransient() {
        return this.config.isSerializeTransient();
    }

    protected T createCopy(Kryo kryo, T original) {
        return (T)kryo.newInstance(original.getClass());
    }

    @Override
    public T copy(Kryo kryo, T original) {
        int i;
        int n;
        T copy2 = this.createCopy(kryo, original);
        kryo.reference(copy2);
        if (this.config.isCopyTransient()) {
            n = this.transientFields.length;
            for (i = 0; i < n; ++i) {
                this.transientFields[i].copy(original, copy2);
            }
        }
        n = this.fields.length;
        for (i = 0; i < n; ++i) {
            this.fields[i].copy(original, copy2);
        }
        return copy2;
    }

    final Generics getGenericsScope() {
        return this.genericsScope;
    }

    static {
        block3: {
            try {
                unsafeUtilClass = FieldSerializer.class.getClassLoader().loadClass("io.hops.hudi.com.esotericsoftware.kryo.util.UnsafeUtil");
                Method unsafeMethod = unsafeUtilClass.getMethod("unsafe", new Class[0]);
                sortFieldsByOffsetMethod = unsafeUtilClass.getMethod("sortFieldsByOffset", List.class);
                Object unsafe = unsafeMethod.invoke(null, new Object[0]);
                if (unsafe != null) {
                    unsafeAvailable = true;
                }
            }
            catch (Throwable e) {
                if (!Log.TRACE) break block3;
                Log.trace("kryo", "sun.misc.Unsafe is unavailable.");
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Bind {
        public Class<? extends Serializer> value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Optional {
        public String value();
    }

    public static interface CachedFieldNameStrategy {
        public static final CachedFieldNameStrategy DEFAULT = new CachedFieldNameStrategy(){

            @Override
            public String getName(CachedField cachedField) {
                return cachedField.field.getName();
            }
        };
        public static final CachedFieldNameStrategy EXTENDED = new CachedFieldNameStrategy(){

            @Override
            public String getName(CachedField cachedField) {
                return cachedField.field.getDeclaringClass().getSimpleName() + "." + cachedField.field.getName();
            }
        };

        public String getName(CachedField var1);
    }

    public static interface CachedFieldFactory {
        public CachedField createCachedField(Class var1, Field var2, FieldSerializer var3);
    }

    public static abstract class CachedField<X> {
        Field field;
        FieldAccess access;
        Class valueClass;
        Serializer serializer;
        boolean canBeNull;
        int accessIndex = -1;
        long offset = -1L;
        boolean varIntsEnabled = true;

        public void setClass(Class valueClass) {
            this.valueClass = valueClass;
            this.serializer = null;
        }

        public void setClass(Class valueClass, Serializer serializer) {
            this.valueClass = valueClass;
            this.serializer = serializer;
        }

        public void setSerializer(Serializer serializer) {
            this.serializer = serializer;
        }

        public Serializer getSerializer() {
            return this.serializer;
        }

        public void setCanBeNull(boolean canBeNull) {
            this.canBeNull = canBeNull;
        }

        public Field getField() {
            return this.field;
        }

        public String toString() {
            return this.field.getName();
        }

        public abstract void write(Output var1, Object var2);

        public abstract void read(Input var1, Object var2);

        public abstract void copy(Object var1, Object var2);
    }
}

