/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.com.esotericsoftware.kryo.util;

import io.hops.hudi.com.esotericsoftware.kryo.ClassResolver;
import io.hops.hudi.com.esotericsoftware.kryo.Kryo;
import io.hops.hudi.com.esotericsoftware.kryo.KryoException;
import io.hops.hudi.com.esotericsoftware.kryo.Registration;
import io.hops.hudi.com.esotericsoftware.kryo.io.Input;
import io.hops.hudi.com.esotericsoftware.kryo.io.Output;
import io.hops.hudi.com.esotericsoftware.kryo.util.IdentityObjectIntMap;
import io.hops.hudi.com.esotericsoftware.kryo.util.IntMap;
import io.hops.hudi.com.esotericsoftware.kryo.util.ObjectMap;
import io.hops.hudi.com.esotericsoftware.kryo.util.Util;
import io.hops.hudi.com.esotericsoftware.minlog.Log;

public class DefaultClassResolver
implements ClassResolver {
    public static final byte NAME = -1;
    protected Kryo kryo;
    protected final IntMap<Registration> idToRegistration = new IntMap();
    protected final ObjectMap<Class, Registration> classToRegistration = new ObjectMap();
    protected IdentityObjectIntMap<Class> classToNameId;
    protected IntMap<Class> nameIdToClass;
    protected ObjectMap<String, Class> nameToClass;
    protected int nextNameId;
    private int memoizedClassId = -1;
    private Registration memoizedClassIdValue;
    private Class memoizedClass;
    private Registration memoizedClassValue;

    @Override
    public void setKryo(Kryo kryo) {
        this.kryo = kryo;
    }

    @Override
    public Registration register(Registration registration) {
        if (registration == null) {
            throw new IllegalArgumentException("registration cannot be null.");
        }
        if (registration.getId() != -1) {
            if (Log.TRACE) {
                Log.trace("kryo", "Register class ID " + registration.getId() + ": " + Util.className(registration.getType()) + " (" + registration.getSerializer().getClass().getName() + ")");
            }
            this.idToRegistration.put(registration.getId(), registration);
        } else if (Log.TRACE) {
            Log.trace("kryo", "Register class name: " + Util.className(registration.getType()) + " (" + registration.getSerializer().getClass().getName() + ")");
        }
        this.classToRegistration.put(registration.getType(), registration);
        if (registration.getType().isPrimitive()) {
            this.classToRegistration.put(Util.getWrapperClass(registration.getType()), registration);
        }
        return registration;
    }

    @Override
    public Registration registerImplicit(Class type2) {
        return this.register(new Registration(type2, this.kryo.getDefaultSerializer(type2), -1));
    }

    @Override
    public Registration getRegistration(Class type2) {
        if (type2 == this.memoizedClass) {
            return this.memoizedClassValue;
        }
        Registration registration = this.classToRegistration.get(type2);
        if (registration != null) {
            this.memoizedClass = type2;
            this.memoizedClassValue = registration;
        }
        return registration;
    }

    @Override
    public Registration getRegistration(int classID) {
        return this.idToRegistration.get(classID);
    }

    @Override
    public Registration writeClass(Output output, Class type2) {
        if (type2 == null) {
            if (Log.TRACE || Log.DEBUG && this.kryo.getDepth() == 1) {
                Util.log("Write", null);
            }
            output.writeVarInt(0, true);
            return null;
        }
        Registration registration = this.kryo.getRegistration(type2);
        if (registration.getId() == -1) {
            this.writeName(output, type2, registration);
        } else {
            if (Log.TRACE) {
                Log.trace("kryo", "Write class " + registration.getId() + ": " + Util.className(type2));
            }
            output.writeVarInt(registration.getId() + 2, true);
        }
        return registration;
    }

    protected void writeName(Output output, Class type2, Registration registration) {
        int nameId;
        output.writeVarInt(1, true);
        if (this.classToNameId != null && (nameId = this.classToNameId.get(type2, -1)) != -1) {
            if (Log.TRACE) {
                Log.trace("kryo", "Write class name reference " + nameId + ": " + Util.className(type2));
            }
            output.writeVarInt(nameId, true);
            return;
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Write class name: " + Util.className(type2));
        }
        nameId = this.nextNameId++;
        if (this.classToNameId == null) {
            this.classToNameId = new IdentityObjectIntMap();
        }
        this.classToNameId.put(type2, nameId);
        output.writeVarInt(nameId, true);
        output.writeString(type2.getName());
    }

    @Override
    public Registration readClass(Input input) {
        int classID = input.readVarInt(true);
        switch (classID) {
            case 0: {
                if (Log.TRACE || Log.DEBUG && this.kryo.getDepth() == 1) {
                    Util.log("Read", null);
                }
                return null;
            }
            case 1: {
                return this.readName(input);
            }
        }
        if (classID == this.memoizedClassId) {
            return this.memoizedClassIdValue;
        }
        Registration registration = this.idToRegistration.get(classID - 2);
        if (registration == null) {
            throw new KryoException("Encountered unregistered class ID: " + (classID - 2));
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Read class " + (classID - 2) + ": " + Util.className(registration.getType()));
        }
        this.memoizedClassId = classID;
        this.memoizedClassIdValue = registration;
        return registration;
    }

    protected Registration readName(Input input) {
        Class<?> type2;
        int nameId = input.readVarInt(true);
        if (this.nameIdToClass == null) {
            this.nameIdToClass = new IntMap();
        }
        if ((type2 = this.nameIdToClass.get(nameId)) == null) {
            String className = input.readString();
            type2 = this.getTypeByName(className);
            if (type2 == null) {
                try {
                    type2 = Class.forName(className, false, this.kryo.getClassLoader());
                }
                catch (ClassNotFoundException ex) {
                    if (Log.WARN) {
                        Log.warn("kryo", "Unable to load class " + className + " with kryo's ClassLoader. Retrying with current..");
                    }
                    try {
                        type2 = Class.forName(className);
                    }
                    catch (ClassNotFoundException e) {
                        throw new KryoException("Unable to find class: " + className, ex);
                    }
                }
                if (this.nameToClass == null) {
                    this.nameToClass = new ObjectMap();
                }
                this.nameToClass.put(className, type2);
            }
            this.nameIdToClass.put(nameId, type2);
            if (Log.TRACE) {
                Log.trace("kryo", "Read class name: " + className);
            }
        } else if (Log.TRACE) {
            Log.trace("kryo", "Read class name reference " + nameId + ": " + Util.className(type2));
        }
        return this.kryo.getRegistration(type2);
    }

    protected Class<?> getTypeByName(String className) {
        return this.nameToClass != null ? this.nameToClass.get(className) : null;
    }

    @Override
    public void reset() {
        if (!this.kryo.isRegistrationRequired()) {
            if (this.classToNameId != null) {
                this.classToNameId.clear(2048);
            }
            if (this.nameIdToClass != null) {
                this.nameIdToClass.clear();
            }
            this.nextNameId = 0;
        }
    }
}

