/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.com.esotericsoftware.kryo.util;

import io.hops.hudi.com.esotericsoftware.minlog.Log;
import java.util.concurrent.ConcurrentHashMap;

public class Util {
    public static final boolean IS_ANDROID;
    @Deprecated
    public static boolean isAndroid;
    private static final ConcurrentHashMap<String, Boolean> classAvailabilities;

    public static boolean isClassAvailable(String className) {
        Boolean result2 = classAvailabilities.get(className);
        if (result2 == null) {
            try {
                Class.forName(className);
                result2 = true;
            }
            catch (Exception e) {
                Log.debug("kryo", "Class not available: " + className);
                result2 = false;
            }
            classAvailabilities.put(className, result2);
        }
        return result2;
    }

    public static Class getWrapperClass(Class type2) {
        if (type2 == Integer.TYPE) {
            return Integer.class;
        }
        if (type2 == Float.TYPE) {
            return Float.class;
        }
        if (type2 == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type2 == Long.TYPE) {
            return Long.class;
        }
        if (type2 == Byte.TYPE) {
            return Byte.class;
        }
        if (type2 == Character.TYPE) {
            return Character.class;
        }
        if (type2 == Short.TYPE) {
            return Short.class;
        }
        if (type2 == Double.TYPE) {
            return Double.class;
        }
        return Void.class;
    }

    public static Class getPrimitiveClass(Class type2) {
        if (type2 == Integer.class) {
            return Integer.TYPE;
        }
        if (type2 == Float.class) {
            return Float.TYPE;
        }
        if (type2 == Boolean.class) {
            return Boolean.TYPE;
        }
        if (type2 == Long.class) {
            return Long.TYPE;
        }
        if (type2 == Byte.class) {
            return Byte.TYPE;
        }
        if (type2 == Character.class) {
            return Character.TYPE;
        }
        if (type2 == Short.class) {
            return Short.TYPE;
        }
        if (type2 == Double.class) {
            return Double.TYPE;
        }
        if (type2 == Void.class) {
            return Void.TYPE;
        }
        return type2;
    }

    public static boolean isWrapperClass(Class type2) {
        return type2 == Integer.class || type2 == Float.class || type2 == Boolean.class || type2 == Long.class || type2 == Byte.class || type2 == Character.class || type2 == Short.class || type2 == Double.class;
    }

    public static void log(String message, Object object) {
        if (object == null) {
            if (Log.TRACE) {
                Log.trace("kryo", message + ": null");
            }
            return;
        }
        Class<?> type2 = object.getClass();
        if (type2.isPrimitive() || type2 == Boolean.class || type2 == Byte.class || type2 == Character.class || type2 == Short.class || type2 == Integer.class || type2 == Long.class || type2 == Float.class || type2 == Double.class || type2 == String.class) {
            if (Log.TRACE) {
                Log.trace("kryo", message + ": " + Util.string(object));
            }
        } else {
            Log.debug("kryo", message + ": " + Util.string(object));
        }
    }

    public static String string(Object object) {
        if (object == null) {
            return "null";
        }
        Class<?> type2 = object.getClass();
        if (type2.isArray()) {
            return Util.className(type2);
        }
        try {
            if (type2.getMethod("toString", new Class[0]).getDeclaringClass() == Object.class) {
                return Log.TRACE ? Util.className(type2) : type2.getSimpleName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            return String.valueOf(object);
        }
        catch (Throwable e) {
            return (Log.TRACE ? Util.className(type2) : type2.getSimpleName()) + "(Exception " + e + " in toString)";
        }
    }

    public static String className(Class type2) {
        if (type2.isArray()) {
            Class elementClass = Util.getElementClass(type2);
            StringBuilder buffer = new StringBuilder(16);
            int n = Util.getDimensionCount(type2);
            for (int i = 0; i < n; ++i) {
                buffer.append("[]");
            }
            return Util.className(elementClass) + buffer;
        }
        if (type2.isPrimitive() || type2 == Object.class || type2 == Boolean.class || type2 == Byte.class || type2 == Character.class || type2 == Short.class || type2 == Integer.class || type2 == Long.class || type2 == Float.class || type2 == Double.class || type2 == String.class) {
            return type2.getSimpleName();
        }
        return type2.getName();
    }

    public static int getDimensionCount(Class arrayClass) {
        int depth = 0;
        for (Class<?> nextClass = arrayClass.getComponentType(); nextClass != null; nextClass = nextClass.getComponentType()) {
            ++depth;
        }
        return depth;
    }

    public static Class getElementClass(Class arrayClass) {
        Class<?> elementClass = arrayClass;
        while (elementClass.getComponentType() != null) {
            elementClass = elementClass.getComponentType();
        }
        return elementClass;
    }

    public static int swapInt(int i) {
        return (i & 0xFF) << 24 | (i & 0xFF00) << 8 | (i & 0xFF0000) >> 8 | i >> 24 & 0xFF;
    }

    public static long swapLong(long value) {
        return (value >> 0 & 0xFFL) << 56 | (value >> 8 & 0xFFL) << 48 | (value >> 16 & 0xFFL) << 40 | (value >> 24 & 0xFFL) << 32 | (value >> 32 & 0xFFL) << 24 | (value >> 40 & 0xFFL) << 16 | (value >> 48 & 0xFFL) << 8 | (value >> 56 & 0xFFL) << 0;
    }

    static {
        isAndroid = IS_ANDROID = "Dalvik".equals(System.getProperty("java.vm.name"));
        classAvailabilities = new ConcurrentHashMap();
    }
}

