/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.com.uber.m3.tally;

import io.hops.hudi.com.uber.m3.tally.AbstractBuckets;
import io.hops.hudi.com.uber.m3.tally.HistogramImpl;
import io.hops.hudi.com.uber.m3.util.Duration;
import java.util.Collections;
import java.util.List;

public class DurationBuckets
extends AbstractBuckets<Duration> {
    public DurationBuckets(Duration[] durations) {
        super((Comparable[])durations);
    }

    @Override
    public Duration getDurationLowerBoundFor(int bucketIndex) {
        return bucketIndex == 0 ? Duration.MIN_VALUE : (Duration)this.buckets.get(bucketIndex - 1);
    }

    @Override
    public Duration getDurationUpperBoundFor(int bucketIndex) {
        return bucketIndex < this.buckets.size() ? (Duration)this.buckets.get(bucketIndex) : Duration.MAX_VALUE;
    }

    @Override
    public int getBucketIndexFor(Duration value) {
        return HistogramImpl.toBucketIndex(Collections.binarySearch(this.buckets, value));
    }

    @Override
    public List<Duration> getDurationUpperBounds() {
        return Collections.unmodifiableList(this.buckets);
    }

    @Override
    public double getValueLowerBoundFor(int bucketIndex) {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public double getValueUpperBoundFor(int bucketIndex) {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public int getBucketIndexFor(double value) {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public List<Double> getValueUpperBounds() {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    @Deprecated
    public Double[] asValues() {
        Double[] values2 = new Double[this.buckets.size()];
        for (int i = 0; i < values2.length; ++i) {
            values2[i] = ((Duration)this.buckets.get(i)).getSeconds();
        }
        return values2;
    }

    @Override
    @Deprecated
    public Duration[] asDurations() {
        return this.buckets.toArray(new Duration[this.buckets.size()]);
    }

    public static DurationBuckets linear(Duration start2, Duration width, int numBuckets) {
        if (numBuckets <= 0) {
            throw new IllegalArgumentException("Must have a positive number of buckets");
        }
        if (width.compareTo(Duration.ZERO) <= 0) {
            throw new IllegalArgumentException("Bucket width must be positive");
        }
        Duration[] buckets = new Duration[numBuckets];
        for (int i = 0; i < numBuckets; ++i) {
            buckets[i] = start2.add(width.multiply(i));
        }
        return new DurationBuckets(buckets);
    }

    public static DurationBuckets exponential(Duration start2, double factor, int numBuckets) {
        if (numBuckets <= 0) {
            throw new IllegalArgumentException("Must have a positive number of buckets");
        }
        if (factor <= 1.0) {
            throw new IllegalArgumentException("Factor must be greater than 1");
        }
        Duration[] buckets = new Duration[numBuckets];
        Duration curDuration = start2;
        for (int i = 0; i < numBuckets; ++i) {
            buckets[i] = curDuration;
            curDuration = curDuration.multiply(factor);
        }
        return new DurationBuckets(buckets);
    }

    public static DurationBuckets custom(Duration ... sortedDurations) {
        if (sortedDurations == null || sortedDurations.length == 0) {
            throw new IllegalArgumentException("at least one upper bucket value has to be specified");
        }
        for (int i = 0; i < sortedDurations.length - 1; ++i) {
            if (sortedDurations[i].compareTo(sortedDurations[i + 1]) < 0) continue;
            throw new IllegalArgumentException("bucketUpperMillis has to be sorted in ascending order with unique values");
        }
        return new DurationBuckets(sortedDurations);
    }
}

