/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.com.uber.m3.tally;

import io.hops.hudi.com.uber.m3.tally.Buckets;
import io.hops.hudi.com.uber.m3.tally.Capabilities;
import io.hops.hudi.com.uber.m3.tally.CapableOf;
import io.hops.hudi.com.uber.m3.tally.Counter;
import io.hops.hudi.com.uber.m3.tally.CounterImpl;
import io.hops.hudi.com.uber.m3.tally.CounterSnapshotImpl;
import io.hops.hudi.com.uber.m3.tally.Gauge;
import io.hops.hudi.com.uber.m3.tally.GaugeImpl;
import io.hops.hudi.com.uber.m3.tally.GaugeSnapshotImpl;
import io.hops.hudi.com.uber.m3.tally.Histogram;
import io.hops.hudi.com.uber.m3.tally.HistogramImpl;
import io.hops.hudi.com.uber.m3.tally.HistogramSnapshotImpl;
import io.hops.hudi.com.uber.m3.tally.MetricBase;
import io.hops.hudi.com.uber.m3.tally.Reportable;
import io.hops.hudi.com.uber.m3.tally.Scope;
import io.hops.hudi.com.uber.m3.tally.ScopeBuilder;
import io.hops.hudi.com.uber.m3.tally.ScopeKey;
import io.hops.hudi.com.uber.m3.tally.Snapshot;
import io.hops.hudi.com.uber.m3.tally.SnapshotImpl;
import io.hops.hudi.com.uber.m3.tally.StatsReporter;
import io.hops.hudi.com.uber.m3.tally.Timer;
import io.hops.hudi.com.uber.m3.tally.TimerImpl;
import io.hops.hudi.com.uber.m3.tally.TimerSnapshotImpl;
import io.hops.hudi.com.uber.m3.util.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;

class ScopeImpl
implements Scope {
    private StatsReporter reporter;
    private String prefix;
    private String separator;
    private ImmutableMap<String, String> tags;
    private Buckets defaultBuckets;
    private ScheduledExecutorService scheduler;
    private Registry registry;
    private final ConcurrentHashMap<String, CounterImpl> counters = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, GaugeImpl> gauges = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, HistogramImpl> histograms = new ConcurrentHashMap();
    private final CopyOnWriteArrayList<Reportable> reportingList = new CopyOnWriteArrayList();
    private final ConcurrentHashMap<String, TimerImpl> timers = new ConcurrentHashMap();

    ScopeImpl(ScheduledExecutorService scheduler, Registry registry, ScopeBuilder builder) {
        this.scheduler = scheduler;
        this.registry = registry;
        this.reporter = builder.reporter;
        this.prefix = builder.prefix;
        this.separator = builder.separator;
        this.tags = builder.tags;
        this.defaultBuckets = builder.defaultBuckets;
    }

    @Override
    public Counter counter(String name2) {
        return this.counters.computeIfAbsent(name2, ignored -> new CounterImpl(this, this.fullyQualifiedName(name2)));
    }

    @Override
    public Gauge gauge(String name2) {
        return this.gauges.computeIfAbsent(name2, ignored -> new GaugeImpl(this, this.fullyQualifiedName(name2)));
    }

    @Override
    public Timer timer(String name2) {
        return this.timers.computeIfAbsent(name2, ignored -> new TimerImpl(this.fullyQualifiedName(name2), this.tags, this.reporter));
    }

    @Override
    public Histogram histogram(String name2, @Nullable Buckets buckets) {
        return this.histograms.computeIfAbsent(name2, ignored -> new HistogramImpl(this, this.fullyQualifiedName(name2), this.tags, Optional.ofNullable(buckets).orElse(this.defaultBuckets)));
    }

    @Override
    public Scope tagged(Map<String, String> tags) {
        return this.subScopeHelper(this.prefix, tags);
    }

    @Override
    public Scope subScope(String name2) {
        return this.subScopeHelper(this.fullyQualifiedName(name2), null);
    }

    @Override
    public Capabilities capabilities() {
        if (this.reporter != null) {
            return this.reporter.capabilities();
        }
        return CapableOf.NONE;
    }

    @Override
    public void close() {
        this.scheduler.shutdown();
        this.reportLoopIteration();
        if (this.reporter != null) {
            this.reporter.close();
        }
    }

    <T extends Reportable> void addToReportingQueue(T metric) {
        this.reportingList.add(metric);
    }

    void report(StatsReporter reporter2) {
        for (Reportable metric : this.reportingList) {
            metric.report(this.tags, reporter2);
        }
    }

    static ScopeKey keyForPrefixedStringMap(String prefix, ImmutableMap<String, String> stringMap) {
        return new ScopeKey(prefix, stringMap);
    }

    String fullyQualifiedName(String name2) {
        if (this.prefix == null || this.prefix.length() == 0) {
            return name2;
        }
        return String.format("%s%s%s", this.prefix, this.separator, name2);
    }

    public Snapshot snapshot() {
        SnapshotImpl snap = new SnapshotImpl();
        for (ScopeImpl subscope : this.registry.subscopes.values()) {
            String name2;
            ScopeKey scopeKey;
            for (Map.Entry<String, CounterImpl> entry : subscope.counters.entrySet()) {
                String name22 = subscope.fullyQualifiedName(entry.getKey());
                scopeKey = ScopeImpl.keyForPrefixedStringMap(name22, this.tags);
                snap.counters().put(scopeKey, new CounterSnapshotImpl(name22, this.tags, entry.getValue().snapshot()));
            }
            for (Map.Entry<String, MetricBase> entry : subscope.gauges.entrySet()) {
                name2 = subscope.fullyQualifiedName(entry.getKey());
                scopeKey = ScopeImpl.keyForPrefixedStringMap(name2, this.tags);
                snap.gauges().put(scopeKey, new GaugeSnapshotImpl(name2, this.tags, ((GaugeImpl)entry.getValue()).snapshot()));
            }
            for (Map.Entry<String, Object> entry : subscope.timers.entrySet()) {
                name2 = subscope.fullyQualifiedName(entry.getKey());
                scopeKey = ScopeImpl.keyForPrefixedStringMap(name2, this.tags);
                snap.timers().put(scopeKey, new TimerSnapshotImpl(name2, this.tags, ((TimerImpl)entry.getValue()).snapshot()));
            }
            for (Map.Entry<String, Object> entry : subscope.histograms.entrySet()) {
                name2 = subscope.fullyQualifiedName(entry.getKey());
                scopeKey = ScopeImpl.keyForPrefixedStringMap(name2, this.tags);
                snap.histograms().put(scopeKey, new HistogramSnapshotImpl(name2, this.tags, ((HistogramImpl)entry.getValue()).snapshotValues(), ((HistogramImpl)entry.getValue()).snapshotDurations()));
            }
        }
        return snap;
    }

    private Scope subScopeHelper(String prefix, Map<String, String> tags) {
        ImmutableMap.Builder<String, String> mapBuilder = new ImmutableMap.Builder<String, String>();
        if (this.tags != null) {
            mapBuilder.putAll(this.tags);
        }
        if (tags != null) {
            mapBuilder.putAll(tags);
        }
        ImmutableMap<String, String> mergedTags = mapBuilder.build();
        ScopeKey key = ScopeImpl.keyForPrefixedStringMap(prefix, mergedTags);
        return this.computeSubscopeIfAbsent(prefix, key, mergedTags);
    }

    protected Scope computeSubscopeIfAbsent(String prefix, ScopeKey key, ImmutableMap<String, String> mergedTags) {
        Scope scope2 = this.registry.subscopes.get(key);
        if (scope2 != null) {
            return scope2;
        }
        return this.registry.subscopes.computeIfAbsent(key, k -> new ScopeBuilder(this.scheduler, this.registry).reporter(this.reporter).prefix(prefix).separator(this.separator).tags(mergedTags).defaultBuckets(this.defaultBuckets).build());
    }

    void reportLoopIteration() {
        Collection<ScopeImpl> subscopes = this.registry.subscopes.values();
        if (this.reporter != null) {
            for (ScopeImpl subscope : subscopes) {
                subscope.report(this.reporter);
            }
            this.reporter.flush();
        }
    }

    static class Registry {
        Map<ScopeKey, ScopeImpl> subscopes = new ConcurrentHashMap<ScopeKey, ScopeImpl>();

        Registry() {
        }
    }

    class ReportLoop
    implements Runnable {
        private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;

        ReportLoop(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            this.uncaughtExceptionHandler = uncaughtExceptionHandler;
        }

        @Override
        public void run() {
            block2: {
                try {
                    ScopeImpl.this.reportLoopIteration();
                }
                catch (Exception uncaughtException) {
                    if (this.uncaughtExceptionHandler == null) break block2;
                    this.reportUncaughtException(uncaughtException);
                }
            }
        }

        private void reportUncaughtException(Exception uncaughtException) {
            try {
                this.uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), uncaughtException);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

