/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.com.uber.m3.tally;

import io.hops.hudi.com.uber.m3.tally.Buckets;
import io.hops.hudi.com.uber.m3.tally.Capabilities;
import io.hops.hudi.com.uber.m3.tally.CapableOf;
import io.hops.hudi.com.uber.m3.tally.StatsReporter;
import io.hops.hudi.com.uber.m3.tally.Stopwatch;
import io.hops.hudi.com.uber.m3.tally.StopwatchRecorder;
import io.hops.hudi.com.uber.m3.tally.Timer;
import io.hops.hudi.com.uber.m3.util.Duration;
import io.hops.hudi.com.uber.m3.util.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

class TimerImpl
implements Timer,
StopwatchRecorder {
    private String name;
    private ImmutableMap<String, String> tags;
    private StatsReporter reporter;
    private Values unreported = new Values();

    TimerImpl(String name2, ImmutableMap<String, String> tags, StatsReporter reporter2) {
        this.name = name2;
        this.tags = tags;
        this.reporter = reporter2 == null ? new NoReporterSink() : reporter2;
    }

    @Override
    public void record(Duration interval) {
        this.reporter.reportTimer(this.name, this.tags, interval);
    }

    @Override
    public Stopwatch start() {
        return new Stopwatch(System.nanoTime(), this);
    }

    @Override
    public void recordStopwatch(long stopwatchStart) {
        this.record(Duration.between(stopwatchStart, System.nanoTime()));
    }

    Duration[] snapshot() {
        this.unreported.readLock().lock();
        Duration[] snap = new Duration[this.unreported.getValues().size()];
        for (int i = 0; i < this.unreported.getValues().size(); ++i) {
            snap[i] = this.unreported.getValues().get(i);
        }
        this.unreported.readLock().unlock();
        return snap;
    }

    class NoReporterSink
    implements StatsReporter {
        NoReporterSink() {
        }

        @Override
        public Capabilities capabilities() {
            return CapableOf.REPORTING_TAGGING;
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }

        @Override
        public void reportCounter(String name2, Map<String, String> tags, long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reportGauge(String name2, Map<String, String> tags, double value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reportTimer(String name2, Map<String, String> tags, Duration interval) {
            TimerImpl.this.unreported.writeLock().lock();
            TimerImpl.this.unreported.getValues().add(interval);
            TimerImpl.this.unreported.writeLock().unlock();
        }

        @Override
        public void reportHistogramValueSamples(String name2, Map<String, String> tags, Buckets buckets, double bucketLowerBound, double bucketUpperBound, long samples) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reportHistogramDurationSamples(String name2, Map<String, String> tags, Buckets buckets, Duration bucketLowerBound, Duration bucketUpperBound, long samples) {
            throw new UnsupportedOperationException();
        }
    }

    static class Values {
        private final ReadWriteLock rwlock = new ReentrantReadWriteLock();
        private List<Duration> values = new ArrayList<Duration>();

        Values() {
        }

        Lock readLock() {
            return this.rwlock.readLock();
        }

        Lock writeLock() {
            return this.rwlock.writeLock();
        }

        public List<Duration> getValues() {
            return this.values;
        }
    }
}

