/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.com.uber.m3.tally.m3;

import io.hops.hudi.com.uber.m3.tally.Buckets;
import io.hops.hudi.com.uber.m3.tally.Capabilities;
import io.hops.hudi.com.uber.m3.tally.CapableOf;
import io.hops.hudi.com.uber.m3.tally.DurationBuckets;
import io.hops.hudi.com.uber.m3.tally.StatsReporter;
import io.hops.hudi.com.uber.m3.tally.ValueBuckets;
import io.hops.hudi.com.uber.m3.tally.m3.SizedMetric;
import io.hops.hudi.com.uber.m3.tally.m3.thrift.TCalcTransport;
import io.hops.hudi.com.uber.m3.tally.m3.thrift.TMultiUdpClient;
import io.hops.hudi.com.uber.m3.tally.m3.thrift.TUdpClient;
import io.hops.hudi.com.uber.m3.thrift.gen.CountValue;
import io.hops.hudi.com.uber.m3.thrift.gen.GaugeValue;
import io.hops.hudi.com.uber.m3.thrift.gen.M3;
import io.hops.hudi.com.uber.m3.thrift.gen.Metric;
import io.hops.hudi.com.uber.m3.thrift.gen.MetricBatch;
import io.hops.hudi.com.uber.m3.thrift.gen.MetricTag;
import io.hops.hudi.com.uber.m3.thrift.gen.MetricValue;
import io.hops.hudi.com.uber.m3.thrift.gen.TimerValue;
import io.hops.hudi.com.uber.m3.util.Duration;
import io.hops.hudi.com.uber.m3.util.ImmutableMap;
import io.hops.hudi.com.uber.m3.util.ListSet;
import io.hops.hudi.org.apache.http.annotation.NotThreadSafe;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class M3Reporter
implements StatsReporter,
AutoCloseable {
    public static final String SERVICE_TAG = "service";
    public static final String ENV_TAG = "env";
    public static final String HOST_TAG = "host";
    public static final String DEFAULT_TAG_VALUE = "default";
    public static final String DEFAULT_HISTOGRAM_BUCKET_ID_NAME = "bucketid";
    public static final String DEFAULT_HISTOGRAM_BUCKET_NAME = "bucket";
    public static final int DEFAULT_HISTOGRAM_BUCKET_TAG_PRECISION = 6;
    static final int NUM_PROCESSORS = 1;
    static final Duration HEARTBEAT_PERIOD = Duration.ofSeconds(10.0);
    private static final Logger LOG = LoggerFactory.getLogger(M3Reporter.class);
    private static final int MAX_PROCESSOR_WAIT_TIMEOUT_MILLIS = 1000;
    private static final int MAX_PROCESSOR_WAIT_ON_CLOSE_MILLIS = 5000;
    private static final int DEFAULT_METRIC_SIZE = 100;
    private static final int DEFAULT_MAX_QUEUE_SIZE = 4096;
    private static final int DEFAULT_MAX_PACKET_SIZE = 65023;
    private static final int THRIFT_METADATA_PADDING = 256;
    private static final int MIN_METRIC_BUCKET_ID_TAG_LENGTH = 4;
    private static final ThreadLocal<SerializedPayloadSizeEstimator> PAYLOAD_SIZE_ESTIMATOR = ThreadLocal.withInitial(() -> new SerializedPayloadSizeEstimator());
    private static final AtomicInteger processorThreadCounter = new AtomicInteger(0);
    private final Duration maxBufferingDelay;
    private final int payloadCapacity;
    private final String bucketIdTagKey;
    private final String bucketValueTagKey;
    private final String bucketValFmt;
    private final Set<MetricTag> commonTags;
    private final Queue<SizedMetric> queue;
    private final ExecutorService executorService;
    private final ScheduledExecutorService scheduledExecutorService;
    private final Clock clock;
    private final CountDownLatch processorsShutdownLatch;
    private final SocketAddress[] collectorEndpointSockedAddresses;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final Processor[] processors;
    private final TProtocolFactory protocolFactory;
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);

    M3Reporter(Builder builder, TProtocolFactory thriftProtocolFactory) {
        this.payloadCapacity = this.calculatePayloadCapacity(builder.maxPacketSizeBytes, builder.metricTagSet);
        this.maxBufferingDelay = Duration.ofMillis(builder.maxProcessorWaitUntilFlushMillis);
        this.bucketIdTagKey = builder.histogramBucketIdName;
        this.bucketValueTagKey = builder.histogramBucketName;
        this.bucketValFmt = String.format("%%.%df", builder.histogramBucketTagPrecision);
        this.queue = new ConcurrentLinkedQueue<SizedMetric>();
        ThreadFactory namedThreadFactory = M3Reporter.createThreadFactory();
        this.executorService = builder.executor != null ? builder.executor : Executors.newFixedThreadPool(1, namedThreadFactory);
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(namedThreadFactory);
        this.clock = Clock.systemUTC();
        this.commonTags = builder.metricTagSet;
        this.protocolFactory = thriftProtocolFactory;
        this.processorsShutdownLatch = new CountDownLatch(1);
        this.collectorEndpointSockedAddresses = builder.endpointSocketAddresses;
        this.processors = new Processor[1];
        for (int i = 0; i < 1; ++i) {
            this.processors[i] = this.bootProcessor(this.collectorEndpointSockedAddresses);
        }
        this.scheduledExecutorService.scheduleAtFixedRate(this::heartbeat, 0L, HEARTBEAT_PERIOD.toMillis(), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void heartbeat() {
        M3Reporter m3Reporter = this;
        synchronized (m3Reporter) {
            for (int i = 0; i < this.processors.length; ++i) {
                if (this.processors[i].getState() == ProcessorState.RUNNING) continue;
                this.processors[i] = this.bootProcessor(this.collectorEndpointSockedAddresses);
            }
        }
    }

    private int calculatePayloadCapacity(int maxPacketSizeBytes, Set<MetricTag> commonTags) {
        MetricBatch metricBatch = new MetricBatch();
        metricBatch.setCommonTags(commonTags);
        metricBatch.setMetrics(new ArrayList<Metric>());
        int thriftRequestShellSize = PAYLOAD_SIZE_ESTIMATOR.get().evaluateThriftRequestWireSize(metricBatch);
        int payloadCapacity = maxPacketSizeBytes - (256 + thriftRequestShellSize);
        if (payloadCapacity <= 0) {
            throw new IllegalArgumentException("Common tags serialized size exceeds packet size");
        }
        return payloadCapacity;
    }

    private static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOG.warn("Unable to determine hostname. Defaulting to: {}", (Object)DEFAULT_TAG_VALUE);
            return DEFAULT_TAG_VALUE;
        }
    }

    private Processor bootProcessor(SocketAddress[] endpointSocketAddresses) {
        try {
            Processor processor = new Processor(endpointSocketAddresses, this.protocolFactory);
            this.executorService.execute(processor);
            return processor;
        }
        catch (SocketException | TTransportException e) {
            LOG.error("Failed to boot processor", e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public Capabilities capabilities() {
        return CapableOf.REPORTING_TAGGING;
    }

    @Override
    public void flush() {
        if (this.isShutdown.get()) {
            return;
        }
        for (Processor processor : this.processors) {
            processor.scheduleFlush();
        }
    }

    @Override
    public void close() {
        if (!this.isShutdown.compareAndSet(false, true)) {
            return;
        }
        this.scheduledExecutorService.shutdownNow();
        this.executorService.shutdownNow();
        try {
            if (!this.processorsShutdownLatch.await(5000L, TimeUnit.MILLISECONDS)) {
                LOG.warn("M3Reporter closing before Processors complete after waiting timeout of {}ms!", (Object)5000);
            }
        }
        catch (InterruptedException e) {
            LOG.warn("M3Reporter closing before Processors complete due to being interrupted!");
        }
    }

    void awaitTermination(Duration timeout) throws InterruptedException {
        this.executorService.awaitTermination(timeout.toMillis(), TimeUnit.MILLISECONDS);
        this.scheduledExecutorService.awaitTermination(timeout.toMillis(), TimeUnit.MILLISECONDS);
    }

    private static Set<MetricTag> toMetricTagSet(Map<String, String> tags) {
        if (tags == null || tags.size() == 0) {
            return new ListSet<MetricTag>();
        }
        ListSet<MetricTag> metricTagSet = new ListSet<MetricTag>(tags.size());
        for (Map.Entry<String, String> tag : tags.entrySet()) {
            metricTagSet.add(M3Reporter.createMetricTag(tag.getKey(), tag.getValue()));
        }
        return metricTagSet;
    }

    private static MetricTag createMetricTag(String tagName, String tagValue) {
        MetricTag metricTag = new MetricTag(tagName);
        if (tagValue != null && !tagValue.isEmpty()) {
            metricTag.setTagValue(tagValue);
        }
        return metricTag;
    }

    private String valueBucketString(double bucketBound) {
        if (bucketBound == Double.MAX_VALUE) {
            return "infinity";
        }
        if (bucketBound == -1.7976931348623157E308) {
            return "-infinity";
        }
        return String.format(this.bucketValFmt, bucketBound);
    }

    private String durationBucketString(Duration bucketBound) {
        if (Duration.ZERO.equals(bucketBound)) {
            return "0";
        }
        if (Duration.MAX_VALUE.equals(bucketBound)) {
            return "infinity";
        }
        if (Duration.MIN_VALUE.equals(bucketBound)) {
            return "-infinity";
        }
        return bucketBound.toString();
    }

    @Override
    public void reportCounter(String name2, Map<String, String> tags, long value) {
        this.reportCounterInternal(name2, tags, value);
    }

    @Override
    public void reportGauge(String name2, Map<String, String> tags, double value) {
        GaugeValue gaugeValue = new GaugeValue();
        gaugeValue.setDValue(value);
        MetricValue metricValue = new MetricValue();
        metricValue.setGauge(gaugeValue);
        Metric metric = this.newMetric(name2, tags, metricValue);
        this.enqueue(new SizedMetric(metric, PAYLOAD_SIZE_ESTIMATOR.get().evaluateByteSize(metric)));
    }

    @Override
    public void reportTimer(String name2, Map<String, String> tags, Duration interval) {
        TimerValue timerValue = new TimerValue();
        timerValue.setI64Value(interval.getNanos());
        MetricValue metricValue = new MetricValue();
        metricValue.setTimer(timerValue);
        Metric metric = this.newMetric(name2, tags, metricValue);
        this.enqueue(new SizedMetric(metric, PAYLOAD_SIZE_ESTIMATOR.get().evaluateByteSize(metric)));
    }

    @Override
    @Deprecated
    public void reportHistogramValueSamples(String name2, Map<String, String> tags, Buckets buckets, double bucketLowerBound, double bucketUpperBound, long samples) {
        this.reportHistogramValueSamples(name2, tags, buckets, buckets.getBucketIndexFor(bucketLowerBound), samples);
    }

    @Override
    @Deprecated
    public void reportHistogramDurationSamples(String name2, Map<String, String> tags, Buckets buckets, Duration bucketLowerBound, Duration bucketUpperBound, long samples) {
        this.reportHistogramValueSamples(name2, tags, buckets, buckets.getBucketIndexFor(bucketLowerBound), samples);
    }

    public void reportHistogramValueSamples(String name2, Map<String, String> tags, Buckets buckets, int bucketIndex, long samples) {
        String bucketValueTag;
        int bucketIdLen = String.valueOf(buckets.size()).length();
        bucketIdLen = Math.max(bucketIdLen, 4);
        String bucketIdFmt = String.format("%%0%sd", bucketIdLen);
        ImmutableMap.Builder<String, String> builder = new ImmutableMap.Builder<String, String>();
        if (tags != null) {
            builder.putAll(tags);
        }
        if (buckets instanceof ValueBuckets) {
            bucketValueTag = String.format("%s-%s", this.valueBucketString(buckets.getValueLowerBoundFor(bucketIndex)), this.valueBucketString(buckets.getValueUpperBoundFor(bucketIndex)));
        } else if (buckets instanceof DurationBuckets) {
            bucketValueTag = String.format("%s-%s", this.durationBucketString(buckets.getDurationLowerBoundFor(bucketIndex)), this.durationBucketString(buckets.getDurationUpperBoundFor(bucketIndex)));
        } else {
            throw new IllegalArgumentException("unsupported buckets format");
        }
        builder.put(this.bucketIdTagKey, String.format(bucketIdFmt, bucketIndex)).put(this.bucketValueTagKey, bucketValueTag);
        this.reportCounterInternal(name2, builder.build(), samples);
    }

    private void reportCounterInternal(String name2, Map<String, String> tags, long value) {
        CountValue countValue = new CountValue();
        countValue.setI64Value(value);
        MetricValue metricValue = new MetricValue();
        metricValue.setCount(countValue);
        Metric metric = this.newMetric(name2, tags, metricValue);
        this.enqueue(new SizedMetric(metric, PAYLOAD_SIZE_ESTIMATOR.get().evaluateByteSize(metric)));
    }

    private Metric newMetric(String name2, Map<String, String> tags, MetricValue metricValue) {
        Metric metric = new Metric(name2);
        metric.setTags(M3Reporter.toMetricTagSet(tags));
        metric.setTimestamp(System.currentTimeMillis() * 1000000L);
        metric.setMetricValue(metricValue);
        return metric;
    }

    private void enqueue(SizedMetric sizedMetric) {
        if (this.isShutdown.get()) {
            return;
        }
        boolean wasEmpty = this.queue.isEmpty();
        boolean enqueued = this.queue.offer(sizedMetric);
        if (!enqueued) {
            LOG.warn("Failed to enqueue metric for emission");
        } else if (wasEmpty) {
            this.signalProcessors();
        }
    }

    private static void runNoThrow(ThrowingRunnable r) {
        try {
            r.run();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void signalProcessors() {
        this.lock.lock();
        try {
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private static ThreadFactory createThreadFactory() {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, String.format("m3-reporter-%d", processorThreadCounter.getAndIncrement()));
            }
        };
    }

    public static class Builder {
        protected SocketAddress[] endpointSocketAddresses;
        protected String service;
        protected String env;
        protected ExecutorService executor;
        protected ImmutableMap<String, String> commonTags = ImmutableMap.EMPTY;
        protected boolean includeHost = false;
        protected int maxPacketSizeBytes = 65023;
        protected int maxProcessorWaitUntilFlushMillis = 1000;
        protected String histogramBucketIdName = "bucketid";
        protected String histogramBucketName = "bucket";
        protected int histogramBucketTagPrecision = 6;
        private Set<MetricTag> metricTagSet;

        public Builder(SocketAddress[] endpointSocketAddresses) {
            if (endpointSocketAddresses == null || endpointSocketAddresses.length == 0) {
                throw new IllegalArgumentException("Must specify at least one SocketAddress");
            }
            this.endpointSocketAddresses = endpointSocketAddresses;
        }

        public Builder(SocketAddress socketAddress) {
            this(new SocketAddress[]{socketAddress});
        }

        public Builder service(String service) {
            this.service = service;
            return this;
        }

        public Builder env(String env) {
            this.env = env;
            return this;
        }

        public Builder executor(ExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder commonTags(ImmutableMap<String, String> commonTags) {
            this.commonTags = commonTags;
            return this;
        }

        public Builder includeHost(boolean includeHost) {
            this.includeHost = includeHost;
            return this;
        }

        @Deprecated
        public Builder maxQueueSize(int maxQueueSize) {
            return this;
        }

        public Builder maxPacketSizeBytes(int maxPacketSizeBytes) {
            this.maxPacketSizeBytes = maxPacketSizeBytes;
            return this;
        }

        public Builder maxProcessorWaitUntilFlushMillis(int maxProcessorWaitUntilFlushMillis) {
            this.maxProcessorWaitUntilFlushMillis = maxProcessorWaitUntilFlushMillis;
            return this;
        }

        public Builder histogramBucketIdName(String histogramBucketIdName) {
            this.histogramBucketIdName = histogramBucketIdName;
            return this;
        }

        public Builder histogramBucketName(String histogramBucketName) {
            this.histogramBucketName = histogramBucketName;
            return this;
        }

        public Builder histogramBucketTagPrecision(int histogramBucketTagPrecision) {
            this.histogramBucketTagPrecision = histogramBucketTagPrecision;
            return this;
        }

        public M3Reporter build() {
            this.metricTagSet = M3Reporter.toMetricTagSet(this.commonTags);
            if (!this.commonTags.containsKey(M3Reporter.SERVICE_TAG)) {
                if (this.service == null || this.service.isEmpty()) {
                    throw new IllegalArgumentException(String.format("Common tag [%s] is required", M3Reporter.SERVICE_TAG));
                }
                this.metricTagSet.add(M3Reporter.createMetricTag(M3Reporter.SERVICE_TAG, this.service));
            }
            if (!this.commonTags.containsKey(M3Reporter.ENV_TAG)) {
                if (this.env == null || this.env.isEmpty()) {
                    throw new IllegalArgumentException(String.format("Common tag [%s] is required", M3Reporter.ENV_TAG));
                }
                this.metricTagSet.add(M3Reporter.createMetricTag(M3Reporter.ENV_TAG, this.env));
            }
            if (this.includeHost && !this.commonTags.containsKey(M3Reporter.HOST_TAG)) {
                this.metricTagSet.add(M3Reporter.createMetricTag(M3Reporter.HOST_TAG, M3Reporter.getHostName()));
            }
            return new M3Reporter(this, (TProtocolFactory)new TCompactProtocol.Factory());
        }
    }

    @NotThreadSafe
    private static class SerializedPayloadSizeEstimator {
        private final TCalcTransport calculatingPhonyTransport = new TCalcTransport();
        private final TProtocol calculatingPhonyProtocol = new TCompactProtocol.Factory().getProtocol((TTransport)this.calculatingPhonyTransport);
        private final M3.Client phonyClient = new M3.Client(this.calculatingPhonyProtocol);

        private SerializedPayloadSizeEstimator() {
        }

        public int evaluateThriftRequestWireSize(MetricBatch metricBatch) {
            try {
                this.phonyClient.emitMetricBatch(metricBatch);
                return this.calculatingPhonyTransport.getSizeAndReset();
            }
            catch (TException e) {
                LOG.warn("Unable to calculate metric batch size", (Throwable)e);
                throw new RuntimeException(e);
            }
        }

        public int evaluateByteSize(Metric metric) {
            try {
                metric.write(this.calculatingPhonyProtocol);
                return this.calculatingPhonyTransport.getSizeAndReset();
            }
            catch (TException e) {
                LOG.warn("Unable to calculate metric batch size. Defaulting to: 100", (Throwable)e);
                return 100;
            }
        }
    }

    @FunctionalInterface
    static interface ThrowingRunnable {
        public void run() throws Exception;
    }

    static enum ProcessorState {
        RUNNING,
        SHUTDOWN;

    }

    private class Processor
    implements Runnable {
        private final List<Metric> metricsBuffer;
        private Instant lastBufferFlushTimestamp;
        private int bufferedBytes;
        private final M3.Client client;
        private final TTransport transport;
        private final AtomicReference<ProcessorState> state;
        private final AtomicBoolean shouldFlush;

        Processor(SocketAddress[] socketAddresses, TProtocolFactory protocolFactory) throws TTransportException, SocketException {
            this.metricsBuffer = new ArrayList<Metric>(M3Reporter.this.payloadCapacity / 10);
            this.lastBufferFlushTimestamp = Instant.now(M3Reporter.this.clock);
            this.bufferedBytes = 0;
            this.state = new AtomicReference();
            this.shouldFlush = new AtomicBoolean(false);
            this.transport = socketAddresses.length > 1 ? new TMultiUdpClient(socketAddresses) : new TUdpClient(socketAddresses[0]);
            this.transport.open();
            this.client = new M3.Client(protocolFactory.getProtocol(this.transport));
            this.state.set(ProcessorState.RUNNING);
            LOG.info("Booted reporting processor");
        }

        @Override
        public void run() {
            while (!M3Reporter.this.isShutdown.get()) {
                try {
                    SizedMetric sizedMetric;
                    if (this.shouldFlush.compareAndSet(true, false)) {
                        this.flushBuffered();
                    }
                    if ((sizedMetric = this.awaitingPoll()) != null) {
                        this.process(sizedMetric);
                        continue;
                    }
                    this.flushBuffered();
                }
                catch (Throwable t) {
                    LOG.error("Unhandled exception in processor", t);
                    break;
                }
            }
            this.state.set(ProcessorState.SHUTDOWN);
            LOG.warn("Processor shutting down");
            this.shutdown();
            LOG.warn("Processor shut down");
        }

        @Nullable
        private SizedMetric awaitingPoll() {
            SizedMetric metric = (SizedMetric)M3Reporter.this.queue.poll();
            if (metric != null) {
                return metric;
            }
            this.await();
            return (SizedMetric)M3Reporter.this.queue.poll();
        }

        private void await() {
            M3Reporter.this.lock.lock();
            try {
                boolean bl = M3Reporter.this.condition.await(M3Reporter.this.maxBufferingDelay.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                M3Reporter.this.lock.unlock();
            }
        }

        private void shutdown() {
            M3Reporter.runNoThrow(this::drainQueue);
            M3Reporter.runNoThrow(this::flushBuffered);
            this.transport.close();
            M3Reporter.this.processorsShutdownLatch.countDown();
        }

        private void process(SizedMetric sizedMetric) throws TException {
            int size = sizedMetric.getSize();
            if (this.bufferedBytes + size > M3Reporter.this.payloadCapacity || this.elapsedMaxDelaySinceLastFlush()) {
                this.flushBuffered();
            }
            Metric metric = sizedMetric.getMetric();
            this.metricsBuffer.add(metric);
            this.bufferedBytes += size;
        }

        private boolean elapsedMaxDelaySinceLastFlush() {
            return Instant.now(M3Reporter.this.clock).isAfter(this.lastBufferFlushTimestamp.plus(M3Reporter.this.maxBufferingDelay.toMillis(), ChronoUnit.MILLIS));
        }

        private void drainQueue() throws TException {
            SizedMetric metrics;
            while ((metrics = (SizedMetric)M3Reporter.this.queue.poll()) != null) {
                this.process(metrics);
            }
        }

        private void flushBuffered() throws TException {
            if (this.metricsBuffer.isEmpty()) {
                return;
            }
            try {
                this.client.emitMetricBatch(new MetricBatch().setCommonTags(M3Reporter.this.commonTags).setMetrics(this.metricsBuffer));
            }
            catch (TException t) {
                LOG.error("Failed to flush metrics", (Throwable)t);
                throw t;
            }
            this.metricsBuffer.clear();
            this.bufferedBytes = 0;
            this.lastBufferFlushTimestamp = Instant.now(M3Reporter.this.clock);
        }

        public void scheduleFlush() {
            this.shouldFlush.set(true);
        }

        public ProcessorState getState() {
            return this.state.get();
        }
    }
}

