/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.com.uber.m3.util;

import io.hops.hudi.com.uber.m3.util.ImmutableList;
import io.hops.hudi.com.uber.m3.util.ImmutableSet;
import java.util.HashMap;
import java.util.Map;

public class ImmutableMap<K, V>
implements Map<K, V> {
    public static final ImmutableMap EMPTY = new ImmutableMap();
    private final HashMap<K, V> map;
    private ImmutableSet<K> keySet;
    private ImmutableList<V> values;
    private ImmutableSet<Map.Entry<K, V>> entrySet;

    private ImmutableMap() {
        this.map = new HashMap(0);
    }

    public ImmutableMap(Map<K, V> map2) {
        this.map = new HashMap<K, V>(map2);
    }

    public static <K, V> ImmutableMap<K, V> of(K key1, V val1) {
        return new Builder<K, V>(1).put(key1, val1).build();
    }

    public static <K, V> ImmutableMap<K, V> of(K key1, V val1, K key2, V val2) {
        return new Builder<K, V>(2).put(key1, val1).put(key2, val2).build();
    }

    public static <K, V> ImmutableMap<K, V> of(K key1, V val1, K key2, V val2, K key3, V val3) {
        return new Builder<K, V>(3).put(key1, val1).put(key2, val2).put(key3, val3).build();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public final V put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void putAll(Map m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ImmutableSet<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new ImmutableSet<K>(this.map.keySet());
        }
        return this.keySet;
    }

    @Override
    public ImmutableList<V> values() {
        if (this.values == null) {
            this.values = new ImmutableList<V>(this.map.values());
        }
        return this.values;
    }

    @Override
    public ImmutableSet<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new ImmutableSet<Map.Entry<K, V>>(this.map.entrySet());
        }
        return this.entrySet;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof ImmutableMap)) {
            return false;
        }
        return this.map.equals(((ImmutableMap)other).map);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    public static class Builder<K, V> {
        private HashMap<K, V> map;

        public Builder() {
            this(16, 0.75f);
        }

        public Builder(int initialCapacity) {
            this(initialCapacity, 1.0f);
        }

        public Builder(int initialCapacity, float loadFactor) {
            this.map = new HashMap(initialCapacity, loadFactor);
        }

        public Builder<K, V> put(K key, V value) {
            this.map.put(key, value);
            return this;
        }

        public Builder<K, V> putAll(Map<K, V> otherMap) {
            this.map.putAll(otherMap);
            return this;
        }

        public ImmutableMap<K, V> build() {
            return new ImmutableMap<K, V>(this.map);
        }
    }
}

