/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hbase.thirdparty.io.netty.handler.codec.spdy;

import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.buffer.ByteBufAllocator;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.buffer.ByteBufUtil;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.buffer.Unpooled;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.handler.codec.spdy.SpdyHeaderBlockEncoder;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.handler.codec.spdy.SpdyHeadersFrame;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.handler.codec.spdy.SpdyVersion;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.util.internal.ObjectUtil;
import java.util.Set;

public class SpdyHeaderBlockRawEncoder
extends SpdyHeaderBlockEncoder {
    private final int version;

    public SpdyHeaderBlockRawEncoder(SpdyVersion version) {
        this.version = ObjectUtil.checkNotNull(version, "version").getVersion();
    }

    private static void setLengthField(ByteBuf buffer, int writerIndex, int length) {
        buffer.setInt(writerIndex, length);
    }

    private static void writeLengthField(ByteBuf buffer, int length) {
        buffer.writeInt(length);
    }

    @Override
    public ByteBuf encode(ByteBufAllocator alloc, SpdyHeadersFrame frame) throws Exception {
        Set names = frame.headers().names();
        int numHeaders = names.size();
        if (numHeaders == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        if (numHeaders > 65535) {
            throw new IllegalArgumentException("header block contains too many headers");
        }
        ByteBuf headerBlock = alloc.heapBuffer();
        SpdyHeaderBlockRawEncoder.writeLengthField(headerBlock, numHeaders);
        for (CharSequence name2 : names) {
            SpdyHeaderBlockRawEncoder.writeLengthField(headerBlock, name2.length());
            ByteBufUtil.writeAscii(headerBlock, name2);
            int savedIndex = headerBlock.writerIndex();
            int valueLength = 0;
            SpdyHeaderBlockRawEncoder.writeLengthField(headerBlock, valueLength);
            for (CharSequence value : frame.headers().getAll(name2)) {
                int length = value.length();
                if (length <= 0) continue;
                ByteBufUtil.writeAscii(headerBlock, value);
                headerBlock.writeByte(0);
                valueLength += length + 1;
            }
            if (valueLength != 0) {
                --valueLength;
            }
            if (valueLength > 65535) {
                throw new IllegalArgumentException("header exceeds allowable length: " + name2);
            }
            if (valueLength <= 0) continue;
            SpdyHeaderBlockRawEncoder.setLengthField(headerBlock, savedIndex, valueLength);
            headerBlock.writerIndex(headerBlock.writerIndex() - 1);
        }
        return headerBlock;
    }

    @Override
    void end() {
    }
}

