/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hbase.thirdparty.org.apache.commons.collections4.map;

import io.hops.hudi.org.apache.hbase.thirdparty.org.apache.commons.collections4.Factory;
import io.hops.hudi.org.apache.hbase.thirdparty.org.apache.commons.collections4.Transformer;
import io.hops.hudi.org.apache.hbase.thirdparty.org.apache.commons.collections4.functors.ConstantTransformer;
import io.hops.hudi.org.apache.hbase.thirdparty.org.apache.commons.collections4.functors.FactoryTransformer;
import io.hops.hudi.org.apache.hbase.thirdparty.org.apache.commons.collections4.map.AbstractMapDecorator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class DefaultedMap<K, V>
extends AbstractMapDecorator<K, V>
implements Serializable {
    private static final long serialVersionUID = 19698628745827L;
    private final Transformer<? super K, ? extends V> value;

    public static <K, V> DefaultedMap<K, V> defaultedMap(Map<K, V> map2, V defaultValue) {
        return new DefaultedMap<K, V>(map2, ConstantTransformer.constantTransformer(defaultValue));
    }

    public static <K, V> DefaultedMap<K, V> defaultedMap(Map<K, V> map2, Factory<? extends V> factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Factory must not be null");
        }
        return new DefaultedMap<K, V>(map2, FactoryTransformer.factoryTransformer(factory));
    }

    public static <K, V> Map<K, V> defaultedMap(Map<K, V> map2, Transformer<? super K, ? extends V> transformer) {
        if (transformer == null) {
            throw new IllegalArgumentException("Transformer must not be null");
        }
        return new DefaultedMap<K, V>(map2, transformer);
    }

    public DefaultedMap(V defaultValue) {
        this(ConstantTransformer.constantTransformer(defaultValue));
    }

    public DefaultedMap(Transformer<? super K, ? extends V> defaultValueTransformer) {
        this(new HashMap(), defaultValueTransformer);
    }

    protected DefaultedMap(Map<K, V> map2, Transformer<? super K, ? extends V> defaultValueTransformer) {
        super(map2);
        if (defaultValueTransformer == null) {
            throw new NullPointerException("Transformer must not be null.");
        }
        this.value = defaultValueTransformer;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.map);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.map = (Map)in.readObject();
    }

    @Override
    public V get(Object key) {
        Object v = this.map.get(key);
        return v != null || this.map.containsKey(key) ? v : this.value.transform(key);
    }
}

