/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hbase.thirdparty.org.apache.commons.collections4.properties;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;

public abstract class AbstractPropertiesFactory<T extends Properties> {
    protected AbstractPropertiesFactory() {
    }

    protected abstract T createProperties();

    public T load(ClassLoader classLoader2, String name2) throws IOException {
        try (InputStream inputStream = classLoader2.getResourceAsStream(name2);){
            T t = this.load(inputStream);
            return t;
        }
    }

    public T load(File file) throws FileNotFoundException, IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            T t = this.load(inputStream);
            return t;
        }
    }

    public T load(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return null;
        }
        T properties2 = this.createProperties();
        ((Properties)properties2).load(inputStream);
        return properties2;
    }

    public T load(Path path) throws IOException {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            T t = this.load(inputStream);
            return t;
        }
    }

    public T load(Reader reader) throws IOException {
        T properties2 = this.createProperties();
        ((Properties)properties2).load(reader);
        return properties2;
    }

    public T load(String name2) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(name2);){
            T t = this.load(inputStream);
            return t;
        }
    }

    public T load(URI uri2) throws IOException {
        return this.load(Paths.get(uri2));
    }

    public T load(URL url2) throws IOException {
        try (InputStream inputStream = url2.openStream();){
            T t = this.load(inputStream);
            return t;
        }
    }
}

