/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.htrace.core;

import io.hops.hudi.org.apache.htrace.core.TraceScope;
import io.hops.hudi.org.apache.htrace.core.Tracer;
import java.util.concurrent.Callable;

public class TraceCallable<V>
implements Callable<V> {
    private final Tracer tracer;
    private final Callable<V> impl;
    private final TraceScope parent;
    private final String description;

    TraceCallable(Tracer tracer, TraceScope parent, Callable<V> impl, String description2) {
        this.tracer = tracer;
        this.impl = impl;
        this.parent = parent;
        this.description = description2 == null ? Thread.currentThread().getName() : description2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V call() throws Exception {
        try (TraceScope chunk = this.tracer.newScope(this.description, this.parent.getSpan().getSpanId());){
            V v = this.impl.call();
            return v;
        }
    }

    public Callable<V> getImpl() {
        return this.impl;
    }
}

