/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind;

import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.core.FormatSchema;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.core.JsonLocation;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.core.JsonParser;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.core.JsonToken;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.DeserializationContext;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.JavaType;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.JsonDeserializer;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.JsonMappingException;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.RuntimeJsonMappingException;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class MappingIterator<T>
implements Iterator<T>,
Closeable {
    protected static final MappingIterator<?> EMPTY_ITERATOR = new MappingIterator(null, null, null, null, false, null);
    protected final JavaType _type;
    protected final DeserializationContext _context;
    protected final JsonDeserializer<T> _deserializer;
    protected JsonParser _parser;
    protected final boolean _closeParser;
    protected boolean _hasNextChecked;
    protected final T _updatedValue;

    @Deprecated
    protected MappingIterator(JavaType type2, JsonParser jp, DeserializationContext ctxt, JsonDeserializer<?> deser) {
        this(type2, jp, ctxt, deser, true, null);
    }

    protected MappingIterator(JavaType type2, JsonParser jp, DeserializationContext ctxt, JsonDeserializer<?> deser, boolean managedParser, Object valueToUpdate) {
        this._type = type2;
        this._parser = jp;
        this._context = ctxt;
        this._deserializer = deser;
        this._closeParser = managedParser;
        this._updatedValue = valueToUpdate == null ? null : valueToUpdate;
        if (managedParser && jp != null && jp.getCurrentToken() == JsonToken.START_ARRAY) {
            jp.clearCurrentToken();
        }
    }

    protected static <T> MappingIterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.hasNextValue();
        }
        catch (JsonMappingException e) {
            throw new RuntimeJsonMappingException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public T next() {
        try {
            return this.nextValue();
        }
        catch (JsonMappingException e) {
            throw new RuntimeJsonMappingException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        if (this._parser != null) {
            this._parser.close();
        }
    }

    public boolean hasNextValue() throws IOException {
        if (this._parser == null) {
            return false;
        }
        if (!this._hasNextChecked) {
            JsonToken t = this._parser.getCurrentToken();
            this._hasNextChecked = true;
            if (t == null && ((t = this._parser.nextToken()) == null || t == JsonToken.END_ARRAY)) {
                JsonParser jp = this._parser;
                this._parser = null;
                if (this._closeParser) {
                    jp.close();
                }
                return false;
            }
        }
        return true;
    }

    public T nextValue() throws IOException {
        T result2;
        if (!this._hasNextChecked && !this.hasNextValue()) {
            throw new NoSuchElementException();
        }
        if (this._parser == null) {
            throw new NoSuchElementException();
        }
        this._hasNextChecked = false;
        if (this._updatedValue == null) {
            result2 = this._deserializer.deserialize(this._parser, this._context);
        } else {
            this._deserializer.deserialize(this._parser, this._context, this._updatedValue);
            result2 = this._updatedValue;
        }
        this._parser.clearCurrentToken();
        return result2;
    }

    public List<T> readAll() throws IOException {
        return this.readAll(new ArrayList());
    }

    public List<T> readAll(List<T> resultList) throws IOException {
        while (this.hasNextValue()) {
            resultList.add(this.nextValue());
        }
        return resultList;
    }

    public JsonParser getParser() {
        return this._parser;
    }

    public FormatSchema getParserSchema() {
        return this._parser.getSchema();
    }

    public JsonLocation getCurrentLocation() {
        return this._parser.getCurrentLocation();
    }
}

