/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.deser.impl;

import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.BeanDescription;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.DeserializationConfig;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.DeserializationContext;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.JavaType;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.deser.CreatorProperty;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.deser.ValueInstantiator;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.deser.std.StdValueInstantiator;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.introspect.AnnotatedMember;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.type.TypeBindings;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CreatorCollector {
    protected final BeanDescription _beanDesc;
    protected final boolean _canFixAccess;
    protected AnnotatedWithParams _defaultConstructor;
    protected AnnotatedWithParams _stringCreator;
    protected AnnotatedWithParams _intCreator;
    protected AnnotatedWithParams _longCreator;
    protected AnnotatedWithParams _doubleCreator;
    protected AnnotatedWithParams _booleanCreator;
    protected AnnotatedWithParams _delegateCreator;
    protected CreatorProperty[] _delegateArgs;
    protected AnnotatedWithParams _propertyBasedCreator;
    protected CreatorProperty[] _propertyBasedArgs = null;
    protected AnnotatedParameter _incompleteParameter;

    public CreatorCollector(BeanDescription beanDesc, boolean canFixAccess) {
        this._beanDesc = beanDesc;
        this._canFixAccess = canFixAccess;
    }

    public ValueInstantiator constructValueInstantiator(DeserializationConfig config) {
        JavaType delegateType;
        boolean maybeVanilla;
        boolean bl = maybeVanilla = this._delegateCreator == null;
        if (maybeVanilla) {
            delegateType = null;
        } else {
            int ix = 0;
            if (this._delegateArgs != null) {
                int len = this._delegateArgs.length;
                for (int i = 0; i < len; ++i) {
                    if (this._delegateArgs[i] != null) continue;
                    ix = i;
                    break;
                }
            }
            TypeBindings bindings = this._beanDesc.bindingsForBeanType();
            delegateType = bindings.resolveType(this._delegateCreator.getGenericParameterType(ix));
        }
        JavaType type2 = this._beanDesc.getType();
        if (maybeVanilla &= this._propertyBasedCreator == null && this._delegateCreator == null && this._stringCreator == null && this._longCreator == null && this._doubleCreator == null && this._booleanCreator == null) {
            Class<?> rawType = type2.getRawClass();
            if (rawType == Collection.class || rawType == List.class || rawType == ArrayList.class) {
                return new Vanilla(1);
            }
            if (rawType == Map.class || rawType == LinkedHashMap.class) {
                return new Vanilla(2);
            }
            if (rawType == HashMap.class) {
                return new Vanilla(3);
            }
        }
        StdValueInstantiator inst = new StdValueInstantiator(config, type2);
        inst.configureFromObjectSettings(this._defaultConstructor, this._delegateCreator, delegateType, this._delegateArgs, this._propertyBasedCreator, this._propertyBasedArgs);
        inst.configureFromStringCreator(this._stringCreator);
        inst.configureFromIntCreator(this._intCreator);
        inst.configureFromLongCreator(this._longCreator);
        inst.configureFromDoubleCreator(this._doubleCreator);
        inst.configureFromBooleanCreator(this._booleanCreator);
        inst.configureIncompleteParameter(this._incompleteParameter);
        return inst;
    }

    public void setDefaultCreator(AnnotatedWithParams creator) {
        this._defaultConstructor = this._fixAccess(creator);
    }

    public void addStringCreator(AnnotatedWithParams creator) {
        this._stringCreator = this.verifyNonDup(creator, this._stringCreator, "String");
    }

    public void addIntCreator(AnnotatedWithParams creator) {
        this._intCreator = this.verifyNonDup(creator, this._intCreator, "int");
    }

    public void addLongCreator(AnnotatedWithParams creator) {
        this._longCreator = this.verifyNonDup(creator, this._longCreator, "long");
    }

    public void addDoubleCreator(AnnotatedWithParams creator) {
        this._doubleCreator = this.verifyNonDup(creator, this._doubleCreator, "double");
    }

    public void addBooleanCreator(AnnotatedWithParams creator) {
        this._booleanCreator = this.verifyNonDup(creator, this._booleanCreator, "boolean");
    }

    public void addDelegatingCreator(AnnotatedWithParams creator, CreatorProperty[] injectables) {
        this._delegateCreator = this.verifyNonDup(creator, this._delegateCreator, "delegate");
        this._delegateArgs = injectables;
    }

    public void addPropertyCreator(AnnotatedWithParams creator, CreatorProperty[] properties2) {
        this._propertyBasedCreator = this.verifyNonDup(creator, this._propertyBasedCreator, "property-based");
        if (properties2.length > 1) {
            HashMap<String, Integer> names = new HashMap<String, Integer>();
            int len = properties2.length;
            for (int i = 0; i < len; ++i) {
                Integer old;
                String name2 = properties2[i].getName();
                if (name2.length() == 0 && properties2[i].getInjectableValueId() != null || (old = names.put(name2, i)) == null) continue;
                throw new IllegalArgumentException("Duplicate creator property \"" + name2 + "\" (index " + old + " vs " + i + ")");
            }
        }
        this._propertyBasedArgs = properties2;
    }

    public void addIncompeteParameter(AnnotatedParameter parameter) {
        if (this._incompleteParameter == null) {
            this._incompleteParameter = parameter;
        }
    }

    public boolean hasDefaultCreator() {
        return this._defaultConstructor != null;
    }

    private <T extends AnnotatedMember> T _fixAccess(T member) {
        if (member != null && this._canFixAccess) {
            ClassUtil.checkAndFixAccess((Member)((Object)member.getAnnotated()));
        }
        return member;
    }

    protected AnnotatedWithParams verifyNonDup(AnnotatedWithParams newOne, AnnotatedWithParams oldOne, String type2) {
        if (oldOne != null && oldOne.getClass() == newOne.getClass()) {
            throw new IllegalArgumentException("Conflicting " + type2 + " creators: already had " + oldOne + ", encountered " + newOne);
        }
        return this._fixAccess(newOne);
    }

    protected static final class Vanilla
    extends ValueInstantiator
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static final int TYPE_COLLECTION = 1;
        public static final int TYPE_MAP = 2;
        public static final int TYPE_HASH_MAP = 3;
        private final int _type;

        public Vanilla(int t) {
            this._type = t;
        }

        @Override
        public String getValueTypeDesc() {
            switch (this._type) {
                case 1: {
                    return ArrayList.class.getName();
                }
                case 2: {
                    return LinkedHashMap.class.getName();
                }
                case 3: {
                    return HashMap.class.getName();
                }
            }
            return Object.class.getName();
        }

        @Override
        public boolean canInstantiate() {
            return true;
        }

        @Override
        public boolean canCreateUsingDefault() {
            return true;
        }

        @Override
        public Object createUsingDefault(DeserializationContext ctxt) throws IOException {
            switch (this._type) {
                case 1: {
                    return new ArrayList();
                }
                case 2: {
                    return new LinkedHashMap();
                }
                case 3: {
                    return new HashMap();
                }
            }
            throw new IllegalStateException("Unknown type " + this._type);
        }
    }
}

