/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.deser.std;

import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.core.Base64Variants;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.core.JsonParser;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.core.JsonToken;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.DeserializationContext;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.DeserializationFeature;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;

@JacksonStdImpl
public final class StringDeserializer
extends StdScalarDeserializer<String> {
    private static final long serialVersionUID = 1L;
    public static final StringDeserializer instance = new StringDeserializer();

    public StringDeserializer() {
        super(String.class);
    }

    @Override
    public String deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken curr = jp.getCurrentToken();
        if (curr == JsonToken.VALUE_STRING) {
            return jp.getText();
        }
        if (curr == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jp.nextToken();
            String parsed = this._parseString(jp, ctxt);
            if (jp.nextToken() != JsonToken.END_ARRAY) {
                throw ctxt.wrongTokenException(jp, JsonToken.END_ARRAY, "Attempted to unwrap single value array for single 'String' value but there was more than a single value in the array");
            }
            return parsed;
        }
        if (curr == JsonToken.VALUE_EMBEDDED_OBJECT) {
            Object ob = jp.getEmbeddedObject();
            if (ob == null) {
                return null;
            }
            if (ob instanceof byte[]) {
                return Base64Variants.getDefaultVariant().encode((byte[])ob, false);
            }
            return ob.toString();
        }
        String text2 = jp.getValueAsString();
        if (text2 != null) {
            return text2;
        }
        throw ctxt.mappingException(this._valueClass, curr);
    }

    @Override
    public String deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return this.deserialize(jp, ctxt);
    }
}

