/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.ser.impl;

import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.core.JsonGenerator;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.BeanProperty;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.JsonMappingException;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.JsonNode;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.JsonSerializer;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.SerializationFeature;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.SerializerProvider;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.introspect.AnnotatedMember;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.jsontype.TypeSerializer;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.ser.ContextualSerializer;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.ser.std.StaticListSerializerBase;
import java.io.IOException;
import java.util.List;

@JacksonStdImpl
public final class IndexedStringListSerializer
extends StaticListSerializerBase<List<String>>
implements ContextualSerializer {
    public static final IndexedStringListSerializer instance = new IndexedStringListSerializer();
    protected final JsonSerializer<String> _serializer;

    protected IndexedStringListSerializer() {
        this((JsonSerializer<?>)null);
    }

    public IndexedStringListSerializer(JsonSerializer<?> ser) {
        super(List.class);
        this._serializer = ser;
    }

    @Override
    protected JsonNode contentSchema() {
        return this.createSchemaNode("string", true);
    }

    @Override
    protected void acceptContentVisitor(JsonArrayFormatVisitor visitor2) throws JsonMappingException {
        visitor2.itemsFormat(JsonFormatTypes.STRING);
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        Object serDef;
        AnnotatedMember m;
        JsonSerializer<Object> ser = null;
        if (property != null && (m = property.getMember()) != null && (serDef = provider.getAnnotationIntrospector().findContentSerializer(m)) != null) {
            ser = provider.serializerInstance(m, serDef);
        }
        if (ser == null) {
            ser = this._serializer;
        }
        if (this.isDefaultSerializer(ser = (ser = this.findConvertingContentSerializer(provider, property, ser)) == null ? provider.findValueSerializer(String.class, property) : provider.handleSecondaryContextualization(ser, property))) {
            ser = null;
        }
        if (ser == this._serializer) {
            return this;
        }
        return new IndexedStringListSerializer(ser);
    }

    @Override
    public void serialize(List<String> value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        int len = value.size();
        if (len == 1 && provider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED)) {
            this._serializeUnwrapped(value, jgen, provider);
            return;
        }
        jgen.writeStartArray();
        if (this._serializer == null) {
            this.serializeContents(value, jgen, provider, len);
        } else {
            this.serializeUsingCustom(value, jgen, provider, len);
        }
        jgen.writeEndArray();
    }

    private final void _serializeUnwrapped(List<String> value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (this._serializer == null) {
            this.serializeContents(value, jgen, provider, 1);
        } else {
            this.serializeUsingCustom(value, jgen, provider, 1);
        }
    }

    @Override
    public void serializeWithType(List<String> value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        int len = value.size();
        typeSer.writeTypePrefixForArray(value, jgen);
        if (this._serializer == null) {
            this.serializeContents(value, jgen, provider, len);
        } else {
            this.serializeUsingCustom(value, jgen, provider, len);
        }
        typeSer.writeTypeSuffixForArray(value, jgen);
    }

    private final void serializeContents(List<String> value, JsonGenerator jgen, SerializerProvider provider, int len) throws IOException {
        int i;
        try {
            for (i = 0; i < len; ++i) {
                String str = value.get(i);
                if (str == null) {
                    provider.defaultSerializeNull(jgen);
                    continue;
                }
                jgen.writeString(str);
            }
        }
        catch (Exception e) {
            this.wrapAndThrow(provider, (Throwable)e, value, i);
        }
    }

    private final void serializeUsingCustom(List<String> value, JsonGenerator jgen, SerializerProvider provider, int len) throws IOException {
        int i = 0;
        try {
            JsonSerializer<String> ser = this._serializer;
            for (i = 0; i < len; ++i) {
                String str = value.get(i);
                if (str == null) {
                    provider.defaultSerializeNull(jgen);
                    continue;
                }
                ser.serialize(str, jgen, provider);
            }
        }
        catch (Exception e) {
            this.wrapAndThrow(provider, (Throwable)e, value, i);
        }
    }
}

