/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.ser.std;

import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.annotation.JsonFormat;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.core.JsonGenerationException;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.core.JsonGenerator;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.core.JsonParser;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.core.SerializableString;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.BeanDescription;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.BeanProperty;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.JavaType;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.JsonMappingException;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.JsonNode;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.JsonSerializer;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.SerializationConfig;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.SerializationFeature;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.SerializerProvider;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.node.ArrayNode;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.node.ObjectNode;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.ser.ContextualSerializer;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.util.EnumValues;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;

@JacksonStdImpl
public class EnumSerializer
extends StdScalarSerializer<Enum<?>>
implements ContextualSerializer {
    protected final EnumValues _values;
    protected final Boolean _serializeAsIndex;

    @Deprecated
    public EnumSerializer(EnumValues v) {
        this(v, null);
    }

    public EnumSerializer(EnumValues v, Boolean serializeAsIndex) {
        super(Enum.class, false);
        this._values = v;
        this._serializeAsIndex = serializeAsIndex;
    }

    public static EnumSerializer construct(Class<Enum<?>> enumClass, SerializationConfig config, BeanDescription beanDesc, JsonFormat.Value format) {
        EnumValues v = EnumValues.construct(config, enumClass);
        Boolean serializeAsIndex = EnumSerializer._isShapeWrittenUsingIndex(enumClass, format, true);
        return new EnumSerializer(v, serializeAsIndex);
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        Boolean serializeAsIndex;
        JsonFormat.Value format;
        if (property != null && (format = prov.getAnnotationIntrospector().findFormat(property.getMember())) != null && (serializeAsIndex = EnumSerializer._isShapeWrittenUsingIndex(property.getType().getRawClass(), format, false)) != this._serializeAsIndex) {
            return new EnumSerializer(this._values, serializeAsIndex);
        }
        return this;
    }

    public EnumValues getEnumValues() {
        return this._values;
    }

    @Override
    public final void serialize(Enum<?> en, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (this._serializeAsIndex(provider)) {
            jgen.writeNumber(en.ordinal());
            return;
        }
        jgen.writeString(this._values.serializedValueFor(en));
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        JavaType type2;
        if (this._serializeAsIndex(provider)) {
            return this.createSchemaNode("integer", true);
        }
        ObjectNode objectNode = this.createSchemaNode("string", true);
        if (typeHint != null && (type2 = provider.constructType(typeHint)).isEnumType()) {
            ArrayNode enumNode = objectNode.putArray("enum");
            for (SerializableString value : this._values.values()) {
                enumNode.add(value.getValue());
            }
        }
        return objectNode;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor2, JavaType typeHint) throws JsonMappingException {
        if (visitor2.getProvider().isEnabled(SerializationFeature.WRITE_ENUMS_USING_INDEX)) {
            JsonIntegerFormatVisitor v2 = visitor2.expectIntegerFormat(typeHint);
            if (v2 != null) {
                v2.numberType(JsonParser.NumberType.INT);
            }
        } else {
            JsonStringFormatVisitor stringVisitor = visitor2.expectStringFormat(typeHint);
            if (typeHint != null && stringVisitor != null && typeHint.isEnumType()) {
                LinkedHashSet<String> enums = new LinkedHashSet<String>();
                for (SerializableString value : this._values.values()) {
                    enums.add(value.getValue());
                }
                stringVisitor.enumTypes(enums);
            }
        }
    }

    protected final boolean _serializeAsIndex(SerializerProvider provider) {
        if (this._serializeAsIndex != null) {
            return this._serializeAsIndex;
        }
        return provider.isEnabled(SerializationFeature.WRITE_ENUMS_USING_INDEX);
    }

    protected static Boolean _isShapeWrittenUsingIndex(Class<?> enumClass, JsonFormat.Value format, boolean fromClass) {
        JsonFormat.Shape shape;
        JsonFormat.Shape shape2 = shape = format == null ? null : format.getShape();
        if (shape == null) {
            return null;
        }
        if (shape == JsonFormat.Shape.ANY || shape == JsonFormat.Shape.SCALAR) {
            return null;
        }
        if (shape == JsonFormat.Shape.STRING) {
            return Boolean.FALSE;
        }
        if (shape.isNumeric()) {
            return Boolean.TRUE;
        }
        throw new IllegalArgumentException("Unsupported serialization shape (" + (Object)((Object)shape) + ") for Enum " + enumClass.getName() + ", not supported as " + (fromClass ? "class" : "property") + " annotation");
    }
}

