/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.ser.std;

import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.core.JsonGenerationException;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.core.JsonGenerator;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.JavaType;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.JsonMappingException;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.JsonNode;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.SerializerProvider;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.jsontype.TypeSerializer;
import io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Type;

@JacksonStdImpl
public class ToStringSerializer
extends StdSerializer<Object> {
    public static final ToStringSerializer instance = new ToStringSerializer();

    public ToStringSerializer() {
        super(Object.class);
    }

    @Override
    public boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        String str = value.toString();
        return str == null || str.length() == 0;
    }

    @Override
    public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        jgen.writeString(value.toString());
    }

    @Override
    public void serializeWithType(Object value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
        typeSer.writeTypePrefixForScalar(value, jgen);
        this.serialize(value, jgen, provider);
        typeSer.writeTypeSuffixForScalar(value, jgen);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor2, JavaType typeHint) throws JsonMappingException {
        if (visitor2 != null) {
            visitor2.expectStringFormat(typeHint);
        }
    }
}

