/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.htrace.shaded.fasterxml.jackson.databind.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ContainerBuilder {
    private static final int MAX_BUF = 1000;
    private Object[] b;
    private int tail;
    private int start;
    private List<Object> list;
    private Map<String, Object> map;

    public ContainerBuilder(int bufSize) {
        this.b = new Object[bufSize & 0xFFFFFFFE];
    }

    public boolean canReuse() {
        return this.list == null && this.map == null;
    }

    public int bufferLength() {
        return this.b.length;
    }

    public int start() {
        if (this.list != null || this.map != null) {
            throw new IllegalStateException();
        }
        int prevStart = this.start;
        this.start = this.tail;
        return prevStart;
    }

    public int startList(Object value) {
        if (this.list != null || this.map != null) {
            throw new IllegalStateException();
        }
        int prevStart = this.start;
        this.start = this.tail;
        this.add(value);
        return prevStart;
    }

    public int startMap(String key, Object value) {
        if (this.list != null || this.map != null) {
            throw new IllegalStateException();
        }
        int prevStart = this.start;
        this.start = this.tail;
        this.put(key, value);
        return prevStart;
    }

    public void add(Object value) {
        if (this.list != null) {
            this.list.add(value);
        } else if (this.tail >= this.b.length) {
            this._expandList(value);
        } else {
            this.b[this.tail++] = value;
        }
    }

    public void put(String key, Object value) {
        if (this.map != null) {
            this.map.put(key, value);
        } else if (this.tail + 2 > this.b.length) {
            this._expandMap(key, value);
        } else {
            this.b[this.tail++] = key;
            this.b[this.tail++] = value;
        }
    }

    public List<Object> finishList(int prevStart) {
        List<Object> l = this.list;
        if (l == null) {
            l = this._buildList(true);
        } else {
            this.list = null;
        }
        this.start = prevStart;
        return l;
    }

    public Object[] finishArray(int prevStart) {
        Object[] result2;
        if (this.list == null) {
            result2 = Arrays.copyOfRange(this.b, this.start, this.tail);
        } else {
            result2 = this.list.toArray(new Object[this.tail - this.start]);
            this.list = null;
        }
        this.start = prevStart;
        return result2;
    }

    public <T> Object[] finishArray(int prevStart, Class<T> elemType) {
        int size = this.tail - this.start;
        Object[] result2 = (Object[])Array.newInstance(elemType, size);
        if (this.list == null) {
            System.arraycopy(this.b, this.start, result2, 0, size);
        } else {
            result2 = this.list.toArray(result2);
            this.list = null;
        }
        this.start = prevStart;
        return result2;
    }

    public Map<String, Object> finishMap(int prevStart) {
        Map<String, Object> m = this.map;
        if (m == null) {
            m = this._buildMap(true);
        } else {
            this.map = null;
        }
        this.start = prevStart;
        return m;
    }

    private void _expandList(Object value) {
        if (this.b.length < 1000) {
            this.b = Arrays.copyOf(this.b, this.b.length << 1);
            this.b[this.tail++] = value;
        } else {
            this.list = this._buildList(false);
            this.list.add(value);
        }
    }

    private List<Object> _buildList(boolean isComplete) {
        int currLen = this.tail - this.start;
        if (isComplete) {
            if (currLen < 2) {
                currLen = 2;
            }
        } else {
            currLen = currLen < 20 ? 20 : (currLen < 1000 ? (currLen += currLen >> 1) : (currLen += currLen >> 2));
        }
        ArrayList<Object> l = new ArrayList<Object>(currLen);
        for (int i = this.start; i < this.tail; ++i) {
            l.add(this.b[i]);
        }
        this.tail = this.start;
        return l;
    }

    private void _expandMap(String key, Object value) {
        if (this.b.length < 1000) {
            this.b = Arrays.copyOf(this.b, this.b.length << 1);
            this.b[this.tail++] = key;
            this.b[this.tail++] = value;
        } else {
            this.map = this._buildMap(false);
            this.map.put(key, value);
        }
    }

    private Map<String, Object> _buildMap(boolean isComplete) {
        int size = this.tail - this.start >> 1;
        size = isComplete ? (size <= 3 ? 4 : (size <= 40 ? (size += size >> 1) : (size += (size >> 2) + (size >> 4)))) : (size < 10 ? 16 : (size < 1000 ? (size += size >> 1) : (size += size / 3)));
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>(size, 0.8f);
        for (int i = this.start; i < this.tail; i += 2) {
            m.put((String)this.b[i], this.b[i + 1]);
        }
        this.tail = this.start;
        return m;
    }
}

